/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DIFF
extends EvalFunc<DataBag> {
    TupleFactory mTupleFactory = TupleFactory.getInstance();
    BagFactory mBagFactory = BagFactory.getInstance();

    @Override
    public DataBag exec(Tuple input) throws IOException {
        if (input.size() != 2) {
            int errCode = 2107;
            String msg = "DIFF expected two inputs but received " + input.size() + " inputs.";
            throw new ExecException(msg, errCode, 4);
        }
        DataBag output = this.mBagFactory.newDefaultBag();
        Object o1 = input.get(0);
        if (o1 instanceof DataBag) {
            DataBag bag1 = (DataBag)o1;
            DataBag bag2 = (DataBag)input.get(1);
            this.computeDiff(bag1, bag2, output);
        } else {
            Object d2;
            Object d1 = input.get(0);
            if (!d1.equals(d2 = input.get(1))) {
                output.add(this.mTupleFactory.newTuple(d1));
                output.add(this.mTupleFactory.newTuple(d2));
            }
        }
        return output;
    }

    private void computeDiff(DataBag bag1, DataBag bag2, DataBag emitTo) {
        HashSet<Tuple> s1 = new HashSet<Tuple>();
        Iterator<Tuple> i1 = bag1.iterator();
        while (i1.hasNext()) {
            s1.add(i1.next());
        }
        HashSet<Tuple> s2 = new HashSet<Tuple>();
        Iterator<Tuple> i2 = bag2.iterator();
        while (i2.hasNext()) {
            s2.add(i2.next());
        }
        for (Tuple t : s1) {
            if (s2.contains(t)) continue;
            emitTo.add(t);
        }
        for (Tuple t : s2) {
            if (s1.contains(t)) continue;
            emitTo.add(t);
        }
    }
}

