/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.datastorage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.datastorage.SeekableInputStream;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.HConfiguration;
import org.apache.pig.backend.hadoop.datastorage.HDataStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HPath
implements ElementDescriptor {
    protected Path path;
    protected HDataStorage fs;

    public HPath(HDataStorage fs, Path parent, Path child) {
        this.path = new Path(parent, child);
        this.fs = fs;
    }

    public HPath(HDataStorage fs, String parent, String child) {
        this(fs, new Path(parent), new Path(child));
    }

    public HPath(HDataStorage fs, Path parent, String child) {
        this(fs, parent, new Path(child));
    }

    public HPath(HDataStorage fs, String parent, Path child) {
        this(fs, new Path(parent), child);
    }

    public HPath(HDataStorage fs, String pathString) {
        this(fs, new Path(pathString));
    }

    public HPath(HDataStorage fs, Path path) {
        this.path = path;
        this.fs = fs;
    }

    @Override
    public DataStorage getDataStorage() {
        return this.fs;
    }

    @Override
    public abstract OutputStream create(Properties var1) throws IOException;

    @Override
    public void copy(ElementDescriptor dstName, Properties dstConfiguration, boolean removeSrc) throws IOException {
        Path dstPath;
        FileSystem dstFS;
        Path srcPath;
        FileSystem srcFS = this.fs.getHFS();
        boolean result = FileUtil.copy((FileSystem)srcFS, (Path)(srcPath = this.path), (FileSystem)(dstFS = ((HPath)dstName).fs.getHFS()), (Path)(dstPath = ((HPath)dstName).path), (boolean)false, (Configuration)new Configuration());
        if (!result) {
            int errCode = 2097;
            String msg = "Failed to copy from: " + this.toString() + " to: " + dstName.toString();
            throw new ExecException(msg, errCode, 4);
        }
    }

    @Override
    public abstract InputStream open() throws IOException;

    @Override
    public abstract SeekableInputStream sopen() throws IOException;

    @Override
    public boolean exists() throws IOException {
        return this.fs.getHFS().exists(this.path);
    }

    @Override
    public void rename(ElementDescriptor newName) throws IOException {
        if (newName != null) {
            this.fs.getHFS().rename(this.path, ((HPath)newName).path);
        }
    }

    @Override
    public void delete() throws IOException {
        this.fs.getHFS().delete(this.path, true);
    }

    @Override
    public Properties getConfiguration() throws IOException {
        HConfiguration props = new HConfiguration();
        long blockSize = this.fs.getHFS().getFileStatus(this.path).getBlockSize();
        short replication = this.fs.getHFS().getFileStatus(this.path).getReplication();
        props.setProperty("pig.path.block.size", Long.valueOf(blockSize).toString());
        props.setProperty("pig.path.block.replication", Short.valueOf(replication).toString());
        return props;
    }

    @Override
    public void updateConfiguration(Properties newConfig) throws IOException {
        if (newConfig == null) {
            return;
        }
        String blkReplStr = newConfig.getProperty("pig.path.block.replication");
        this.fs.getHFS().setReplication(this.path, new Short(blkReplStr).shortValue());
    }

    @Override
    public Map<String, Object> getStatistics() throws IOException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        FileStatus fileStatus = this.fs.getHFS().getFileStatus(this.path);
        props.put("pig.path.block.size", fileStatus.getBlockSize());
        props.put("pig.path.block.replication", fileStatus.getReplication());
        props.put("pig.path.length", fileStatus.getLen());
        props.put("pig.path.modification.time", fileStatus.getModificationTime());
        return props;
    }

    @Override
    public OutputStream create() throws IOException {
        return this.create(null);
    }

    @Override
    public void copy(ElementDescriptor dstName, boolean removeSrc) throws IOException {
        this.copy(dstName, null, removeSrc);
    }

    public Path getPath() {
        return this.path;
    }

    public FileSystem getHFS() {
        return this.fs.getHFS();
    }

    @Override
    public boolean systemElement() {
        return this.path != null && (this.path.getName().startsWith("_") || this.path.getName().startsWith("."));
    }

    public String toString() {
        return this.path.makeQualified(this.getHFS()).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HPath)) {
            return false;
        }
        return this.path.equals((Object)((HPath)obj).path);
    }

    @Override
    public int compareTo(ElementDescriptor other) {
        return this.path.compareTo((Object)((HPath)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

