/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigSequenceFileInputFormat<K, V>
extends SequenceFileInputFormat<K, V> {
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths((JobContext)job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        for (int i = 0; i < dirs.length; ++i) {
            Path p = dirs[i];
            FileSystem fs = p.getFileSystem(job.getConfiguration());
            FileStatus[] matches = fs.globStatus(p, hiddenFileFilter);
            if (matches == null) {
                throw new IOException("Input path does not exist: " + p);
            }
            if (matches.length == 0) {
                throw new IOException("Input Pattern " + p + " matches 0 files");
            }
            for (FileStatus globStat : matches) {
                files.add(globStat);
            }
        }
        return MapRedUtil.getAllFileRecursively(files, job.getConfiguration());
    }
}

