/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POBinCond
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    ExpressionOperator cond;
    ExpressionOperator lhs;
    ExpressionOperator rhs;
    private transient List<ExpressionOperator> child;

    public POBinCond(OperatorKey k) {
        super(k);
    }

    public POBinCond(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POBinCond(OperatorKey k, int rp, ExpressionOperator cond, ExpressionOperator lhs, ExpressionOperator rhs) {
        super(k, rp);
        this.cond = cond;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Result genericGetNext(Object obj, byte dataType) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, obj, dataType);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        Result result = (Boolean)res.result == true ? this.lhs.getNext(obj, dataType) : this.rhs.getNext(obj, dataType);
        this.illustratorMarkup(null, result.result, (Boolean)res.result != false ? 0 : 1);
        return result;
    }

    @Override
    public Result getNext(Boolean b) throws ExecException {
        Result r = this.accumChild(null, b);
        if (r != null) {
            return r;
        }
        Result res = this.cond.getNext(b);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(b) : this.rhs.getNext(b);
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        return this.genericGetNext(db, (byte)120);
    }

    @Override
    public Result getNext(DataByteArray ba) throws ExecException {
        return this.genericGetNext(ba, (byte)50);
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        return this.genericGetNext(d, (byte)25);
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        return this.genericGetNext(f, (byte)20);
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        return this.genericGetNext(i, (byte)10);
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        return this.genericGetNext(l, (byte)15);
    }

    @Override
    public Result getNext(Map m) throws ExecException {
        return this.genericGetNext(m, (byte)100);
    }

    @Override
    public Result getNext(String s) throws ExecException {
        return this.genericGetNext(s, (byte)55);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        return this.genericGetNext(t, (byte)110);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitBinCond(this);
    }

    @Override
    public String name() {
        return "POBinCond[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public void attachInput(Tuple t) {
        this.cond.attachInput(t);
        this.lhs.attachInput(t);
        this.rhs.attachInput(t);
    }

    public void setCond(ExpressionOperator condOp) {
        this.cond = condOp;
    }

    public void setRhs(ExpressionOperator rhs) {
        this.rhs = rhs;
    }

    public void setLhs(ExpressionOperator lhs) {
        this.lhs = lhs;
    }

    public ExpressionOperator getCond() {
        return this.cond;
    }

    public ExpressionOperator getRhs() {
        return this.rhs;
    }

    public ExpressionOperator getLhs() {
        return this.lhs;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public POBinCond clone() throws CloneNotSupportedException {
        POBinCond clone = new POBinCond(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        clone.cond = this.cond.clone();
        clone.lhs = this.lhs.clone();
        clone.rhs = this.rhs.clone();
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        if (this.child == null) {
            this.child = new ArrayList<ExpressionOperator>();
            this.child.add(this.cond);
            this.child.add(this.lhs);
            this.child.add(this.rhs);
        }
        return this.child;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            // empty if block
        }
        return null;
    }
}

