/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POCombinerPackage
extends POPackage {
    private static final long serialVersionUID = 1L;
    private static BagFactory mBagFactory = BagFactory.getInstance();
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private boolean[] mBags;
    private Map<Integer, Integer> keyLookup;
    private int numBags;

    public POCombinerPackage(POPackage pkg, boolean[] bags) {
        super(new OperatorKey(pkg.getOperatorKey().scope, NodeIdGenerator.getGenerator().getNextNodeId(pkg.getOperatorKey().scope)), pkg.getRequestedParallelism(), pkg.getInputs());
        int i;
        this.resultType = pkg.getResultType();
        this.keyType = pkg.keyType;
        this.numInputs = 1;
        this.inner = new boolean[1];
        for (i = 0; i < pkg.inner.length; ++i) {
            this.inner[i] = true;
        }
        if (bags != null) {
            this.mBags = Arrays.copyOf(bags, bags.length);
        }
        this.numBags = 0;
        for (i = 0; i < this.mBags.length; ++i) {
            if (!this.mBags[i]) continue;
            ++this.numBags;
        }
    }

    @Override
    public String name() {
        return "POCombinerPackage[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + " - " + this.mKey.toString();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitCombinerPackage(this);
    }

    @Override
    public void setKeyInfo(Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo) {
        this.keyInfo = keyInfo;
        Pair<Boolean, Map<Integer, Integer>> lrKeyInfo = keyInfo.get(0);
        this.keyLookup = (Map)lrKeyInfo.second;
    }

    private DataBag createDataBag(int numBags) {
        String bagType = null;
        if (PigMapReduce.sJobConfInternal.get() != null) {
            bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.type");
        }
        if (bagType != null && bagType.equalsIgnoreCase("default")) {
            return new NonSpillableDataBag();
        }
        return new InternalCachedBag(numBags);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        int keyField = -1;
        Object[] fields = new Object[this.mBags.length];
        for (int i = 0; i < this.mBags.length; ++i) {
            if (!this.mBags[i]) continue;
            fields[i] = this.createDataBag(this.numBags);
        }
        while (this.tupIter.hasNext()) {
            NullableTuple ntup = (NullableTuple)this.tupIter.next();
            Tuple tup = (Tuple)ntup.getValueAsPigType();
            int tupIndex = 0;
            for (int i = 0; i < this.mBags.length; ++i) {
                Integer keyIndex = this.keyLookup.get(i);
                if (keyIndex == null && this.mBags[i]) {
                    ((DataBag)fields[i]).add((Tuple)tup.get(tupIndex));
                    ++tupIndex;
                    continue;
                }
                fields[i] = this.key;
            }
        }
        Tuple res = mTupleFactory.newTuple(this.mBags.length);
        for (int i = 0; i < this.mBags.length; ++i) {
            res.set(i, fields[i]);
        }
        Result r = new Result();
        r.result = res;
        r.returnStatus = 0;
        return r;
    }
}

