/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.DoubleMax;
import org.apache.pig.builtin.FloatMax;
import org.apache.pig.builtin.IntMax;
import org.apache.pig.builtin.LongMax;
import org.apache.pig.builtin.StringMax;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAX
extends EvalFunc<Double>
implements Algebraic,
Accumulator<Double> {
    private Double intermediateMax = null;

    @Override
    public Double exec(Tuple input) throws IOException {
        try {
            return MAX.max(input);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing max in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Double max(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double curMax = Double.NEGATIVE_INFINITY;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d;
                DataByteArray dba = (DataByteArray)t.get(0);
                Double d2 = d = dba != null ? Double.valueOf(dba.toString()) : null;
                if (d == null) continue;
                sawNonNull = true;
                curMax = Math.max(curMax, d);
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing max of doubles.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return new Double(curMax);
        }
        return null;
    }

    protected static Double maxDoubles(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double curMax = Double.NEGATIVE_INFINITY;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d = (Double)t.get(0);
                if (d == null) continue;
                sawNonNull = true;
                curMax = Math.max(curMax, d);
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing max of doubles.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return new Double(curMax);
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(this.getClass().getName(), Schema.generateNestedSchema((byte)120, 50)));
        funcList.add(new FuncSpec(DoubleMax.class.getName(), Schema.generateNestedSchema((byte)120, 25)));
        funcList.add(new FuncSpec(FloatMax.class.getName(), Schema.generateNestedSchema((byte)120, 20)));
        funcList.add(new FuncSpec(IntMax.class.getName(), Schema.generateNestedSchema((byte)120, 10)));
        funcList.add(new FuncSpec(LongMax.class.getName(), Schema.generateNestedSchema((byte)120, 15)));
        funcList.add(new FuncSpec(StringMax.class.getName(), Schema.generateNestedSchema((byte)120, 55)));
        return funcList;
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Double curMax = MAX.max(b);
            if (curMax == null) {
                return;
            }
            if (this.intermediateMax == null) {
                this.intermediateMax = Double.NEGATIVE_INFINITY;
            }
            this.intermediateMax = Math.max(this.intermediateMax, curMax);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing min in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateMax = null;
    }

    @Override
    public Double getValue() {
        return this.intermediateMax;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final
    extends EvalFunc<Double> {
        @Override
        public Double exec(Tuple input) throws IOException {
            try {
                return MAX.maxDoubles(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(MAX.maxDoubles(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                DataByteArray dba = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    dba = (DataByteArray)tp.get(0);
                }
                return tfact.newTuple(dba != null ? Double.valueOf(dba.toString()) : null);
            }
            catch (NumberFormatException e) {
                Tuple t = tfact.newTuple(1);
                t.set(0, null);
                return t;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing max in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

