/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackageLite;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.NullableTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnceBag
implements DataBag {
    POPackageLite pkg;
    transient Iterator<NullableTuple> tupIter;
    Object key;
    protected static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private static final long serialVersionUID = 2L;

    public ReadOnceBag(POPackageLite pkg, Iterator<NullableTuple> tupIter, Object key) {
        this.pkg = pkg;
        this.tupIter = tupIter;
        this.key = key;
    }

    @Override
    public long getMemorySize() {
        throw new RuntimeException("ReadOnceBag does not support getMemorySize operation");
    }

    @Override
    public long spill() {
        throw new RuntimeException("ReadOnceBag does not support spill operation");
    }

    @Override
    public void add(Tuple t) {
        throw new RuntimeException("ReadOnceBag does not support add operation");
    }

    @Override
    public void addAll(DataBag b) {
        throw new RuntimeException("ReadOnceBag does not support addAll operation");
    }

    @Override
    public void clear() {
        throw new RuntimeException("ReadOnceBag does not support clear operation");
    }

    @Override
    public boolean isDistinct() {
        throw new RuntimeException("ReadOnceBag does not support isDistinct operation");
    }

    @Override
    public boolean isSorted() {
        throw new RuntimeException("ReadOnceBag does not support isSorted operation");
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new ReadOnceBagIterator();
    }

    @Override
    public void markStale(boolean stale) {
        throw new RuntimeException("ReadOnceBag does not support markStale operation");
    }

    @Override
    public long size() {
        throw new RuntimeException("ReadOnceBag does not support size operation");
    }

    public void readFields(DataInput in) throws IOException {
        throw new RuntimeException("ReadOnceBag does not support readFields operation");
    }

    public void write(DataOutput out) throws IOException {
        int errCode = 2142;
        String msg = "ReadOnceBag should never be serialized.";
        throw new ExecException(msg, errCode, 4);
    }

    public int compareTo(Object o) {
        throw new RuntimeException("ReadOnceBags cannot be compared");
    }

    public boolean equals(Object other) {
        if (other instanceof ReadOnceBag) {
            if (this.pkg.getKeyTuple()) {
                return this.tupIter == ((ReadOnceBag)other).tupIter && this.pkg.getKeyTuple() == ((ReadOnceBag)other).pkg.getKeyTuple() && this.pkg.getKeyAsTuple().equals(((ReadOnceBag)other).pkg.getKeyAsTuple());
            }
            return this.tupIter == ((ReadOnceBag)other).tupIter && this.pkg.getKey().equals(((ReadOnceBag)other).pkg.getKey());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = this.pkg.getKeyTuple() ? hash * 31 + this.pkg.getKeyAsTuple().hashCode() : hash * 31 + this.pkg.getKey().hashCode();
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReadOnceBagIterator
    implements Iterator<Tuple> {
        ReadOnceBagIterator() {
        }

        @Override
        public boolean hasNext() {
            return ReadOnceBag.this.tupIter.hasNext();
        }

        @Override
        public Tuple next() {
            NullableTuple ntup = ReadOnceBag.this.tupIter.next();
            byte index = ntup.getIndex();
            Tuple ret = null;
            try {
                ret = ReadOnceBag.this.pkg.getValueTuple(ntup, index, ReadOnceBag.this.key);
            }
            catch (ExecException e) {
                throw new RuntimeException("ReadOnceBag failed to get value tuple : " + e.toString());
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new RuntimeException("ReadOnceBag.iterator().remove() is not allowed");
        }
    }
}

