/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.tools.bzip2r.CBZip2InputStream;

public class BufferedPositionedInputStream
extends InputStream {
    long pos;
    InputStream in;
    static final int bufSize = 1024;
    private byte[] barray = new byte[1024];
    private ByteBuffer bbuff = ByteBuffer.wrap(this.barray);
    private char[] carray = new char[1024];
    private CharBuffer cbuff = CharBuffer.wrap(this.carray);

    public BufferedPositionedInputStream(InputStream in, long pos) {
        this.in = in instanceof CBZip2InputStream ? in : new BufferedInputStream(in, 1024);
        this.pos = pos;
    }

    public BufferedPositionedInputStream(InputStream in) {
        this(in, 0L);
    }

    public int read() throws IOException {
        int c = this.in.read();
        ++this.pos;
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.pos += (long)read;
        return read;
    }

    public long skip(long n) throws IOException {
        long rc = this.in.skip(n);
        this.pos += rc;
        return rc;
    }

    public long getPosition() throws IOException {
        if (this.in instanceof CBZip2InputStream) {
            return ((CBZip2InputStream)this.in).getPos();
        }
        return this.pos;
    }

    public String readLine(Charset charset, byte delimiter) throws IOException {
        CoderResult res;
        int rc;
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        int delim = delimiter & 0xFF;
        int offset = 0;
        StringBuilder sb = null;
        while ((rc = this.read()) != -1 && rc != delim) {
            this.barray[offset++] = (byte)rc;
            if (this.barray.length != offset) continue;
            this.bbuff.position(0);
            this.bbuff.limit(this.barray.length);
            this.cbuff.position(0);
            this.cbuff.limit(this.carray.length);
            res = decoder.decode(this.bbuff, this.cbuff, false);
            if (res.isError()) {
                throw new IOException("Decoding error: " + res.toString());
            }
            offset = this.bbuff.remaining();
            switch (offset) {
                default: {
                    System.arraycopy(this.barray, this.bbuff.position(), this.barray, 0, this.bbuff.remaining());
                    break;
                }
                case 2: {
                    this.barray[1] = this.barray[this.barray.length - 1];
                    this.barray[0] = this.barray[this.barray.length - 2];
                    break;
                }
                case 1: {
                    this.barray[0] = this.barray[this.barray.length - 1];
                }
                case 0: 
            }
            if (sb == null) {
                sb = new StringBuilder(this.cbuff.position());
            }
            sb.append(this.carray, 0, this.cbuff.position());
        }
        if (sb == null) {
            if (rc == -1 && offset == 0) {
                return null;
            }
            sb = new StringBuilder();
        }
        this.bbuff.position(0);
        this.bbuff.limit(offset);
        this.cbuff.position(0);
        this.cbuff.limit(this.carray.length);
        res = decoder.decode(this.bbuff, this.cbuff, true);
        if (res.isError()) {
            System.out.println("Error");
        }
        sb.append(this.carray, 0, this.cbuff.position());
        this.cbuff.position(0);
        res = decoder.flush(this.cbuff);
        if (res.isError()) {
            System.out.println("Error");
        }
        sb.append(this.carray, 0, this.cbuff.position());
        return sb.toString();
    }

    public void close() throws IOException {
        super.close();
        this.in.close();
    }
}

