/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<K, V>
implements Serializable {
    static final long serialVersionUID = 2L;
    protected Map<K, ArrayList<V>> mMap = null;

    public MultiMap() {
        this.mMap = new HashMap<K, ArrayList<V>>();
    }

    public MultiMap(int size) {
        this.mMap = new HashMap<K, ArrayList<V>>(size);
    }

    public void put(K key, V value) {
        ArrayList<Object> list = this.mMap.get(key);
        if (list == null) {
            list = new ArrayList();
            list.add(value);
            this.mMap.put(key, list);
        } else {
            list.add(value);
        }
    }

    public void put(K key, Collection<V> values) {
        ArrayList<V> list = this.mMap.get(key);
        if (list == null) {
            list = new ArrayList<V>(values);
            this.mMap.put(key, list);
        } else {
            list.addAll(values);
        }
    }

    public List<V> get(K key) {
        return this.mMap.get(key);
    }

    public V remove(K key, V value) {
        ArrayList<V> list = this.mMap.get(key);
        if (list == null) {
            return null;
        }
        Iterator<V> i = list.iterator();
        Object keeper = null;
        while (i.hasNext()) {
            keeper = i.next();
            if (!keeper.equals(value)) continue;
            i.remove();
            break;
        }
        if (list.size() == 0) {
            this.mMap.remove(key);
        }
        return (V)keeper;
    }

    public Collection<V> removeKey(K key) {
        return this.mMap.remove(key);
    }

    public Set<K> keySet() {
        return this.mMap.keySet();
    }

    public Collection<V> values() {
        Set<K> keys = this.mMap.keySet();
        int size = 0;
        for (K k : keys) {
            size += this.mMap.get(k).size();
        }
        ArrayList values = new ArrayList(size);
        for (K k : keys) {
            values.addAll(this.mMap.get(k));
        }
        return values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<K> keys = this.mMap.keySet();
        boolean hasNext = false;
        sb.append("{");
        for (K k : keys) {
            if (hasNext) {
                sb.append(",");
            } else {
                hasNext = true;
            }
            sb.append(k.toString() + "=");
            sb.append(this.mMap.get(k));
        }
        sb.append("}");
        return sb.toString();
    }

    public int size() {
        return this.mMap.size();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public void clear() {
        this.mMap.clear();
    }

    public boolean containsKey(K key) {
        return this.mMap.containsKey(key);
    }

    public boolean containsValue(V val) {
        return this.mMap.containsValue(val);
    }
}

