/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.SourceLocation;

public class LOInnerLoad
extends LogicalRelationalOperator {
    private ProjectExpression prj;
    private LOForEach foreach;
    private boolean sourceIsBag = false;

    public LOInnerLoad(OperatorPlan plan, LOForEach foreach, int colNum) {
        super("LOInnerLoad", plan);
        LogicalExpressionPlan exp = new LogicalExpressionPlan();
        this.prj = new ProjectExpression((OperatorPlan)exp, 0, colNum, (LogicalRelationalOperator)foreach);
        this.foreach = foreach;
    }

    public LOInnerLoad(OperatorPlan plan, LOForEach foreach, String colAlias) throws FrontendException {
        super("LOInnerLoad", plan);
        LogicalExpressionPlan exp = new LogicalExpressionPlan();
        this.prj = new ProjectExpression((OperatorPlan)exp, 0, colAlias, (LogicalRelationalOperator)foreach);
        this.foreach = foreach;
    }

    public LOInnerLoad(LogicalPlan plan, LOForEach foreach, ProjectExpression projectExpression) {
        super("LOInnerLoad", plan);
        this.prj = projectExpression;
        this.prj.setInputNum(0);
        this.prj.setAttachedRelationalOp(foreach);
        this.foreach = foreach;
    }

    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        if (this.prj.findReferent().getSchema() != null && this.prj.getFieldSchema() != null) {
            if (this.prj.getFieldSchema().type == 120) {
                LogicalSchema.LogicalFieldSchema tupleSchema;
                this.sourceIsBag = true;
                this.alias = this.prj.getFieldSchema().alias;
                if (this.prj.getFieldSchema().schema != null && (tupleSchema = this.prj.getFieldSchema().schema.getField(0)) != null && tupleSchema.schema != null) {
                    this.schema = new LogicalSchema();
                    for (int i = 0; i < tupleSchema.schema.size(); ++i) {
                        this.schema.addField(tupleSchema.schema.getField(i));
                    }
                }
            } else {
                this.schema = new LogicalSchema();
                this.schema.addField(this.prj.getFieldSchema());
            }
        } else if (!this.prj.isRangeOrStarProject()) {
            this.schema = new LogicalSchema();
            this.schema.addField(new LogicalSchema.LogicalFieldSchema(null, null, 50));
        }
        return this.schema;
    }

    public void resetSchema() {
        super.resetSchema();
        this.prj.resetFieldSchema();
    }

    public ProjectExpression getProjection() {
        return this.prj;
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (!(other instanceof LOInnerLoad)) {
            return false;
        }
        return this.getColNum() == ((LOInnerLoad)other).getColNum();
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public int getColNum() {
        return this.prj.getColNum();
    }

    public LOForEach getLOForEach() {
        return this.foreach;
    }

    public boolean sourceIsBag() {
        return this.sourceIsBag;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.alias != null) {
            msg.append(this.alias + ": ");
        }
        msg.append("(Name: " + this.name);
        msg.append("[");
        if (this.getProjection().getColAlias() != null) {
            msg.append(this.getProjection().getColAlias());
        } else if (this.getProjection().isProjectStar()) {
            msg.append("*");
        } else if (this.getProjection().isRangeProject()) {
            msg.append(this.getProjection().getStartCol()).append(" .. ").append(this.getProjection().getEndCol());
        } else {
            msg.append(this.getProjection().getColNum());
        }
        msg.append("]");
        msg.append(" Schema: ");
        if (this.schema != null) {
            msg.append(this.schema);
        } else {
            msg.append("null");
        }
        msg.append(")");
        if (this.annotations != null) {
            for (Map.Entry entry : this.annotations.entrySet()) {
                msg.append(entry);
            }
        }
        return msg.toString();
    }

    public void setLocation(SourceLocation loc) {
        super.setLocation(loc);
        this.prj.setLocation(loc);
    }
}

