/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.h2.mvstore.DataUtils;

public class Chunk {
    final int id;
    long start;
    int length;
    int pageCount;
    long maxLength;
    long maxLengthLive;
    int collectPriority;
    long metaRootPos;
    long version;

    Chunk(int n) {
        this.id = n;
    }

    static Chunk fromHeader(ByteBuffer byteBuffer, long l) {
        if (byteBuffer.get() != 99) {
            throw new RuntimeException("File corrupt");
        }
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        long l2 = byteBuffer.getLong();
        long l3 = byteBuffer.getLong();
        long l4 = byteBuffer.getLong();
        Chunk chunk = new Chunk(n2);
        chunk.length = n;
        chunk.pageCount = n3;
        chunk.start = l;
        chunk.metaRootPos = l2;
        chunk.maxLength = l3;
        chunk.maxLengthLive = l4;
        return chunk;
    }

    void writeHeader(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)99);
        byteBuffer.putInt(this.length);
        byteBuffer.putInt(this.id);
        byteBuffer.putInt(this.pageCount);
        byteBuffer.putLong(this.metaRootPos);
        byteBuffer.putLong(this.maxLength);
        byteBuffer.putLong(this.maxLengthLive);
    }

    public static Chunk fromString(String string) {
        HashMap<String, String> hashMap = DataUtils.parseMap(string);
        int n = Integer.parseInt(hashMap.get("id"));
        Chunk chunk = new Chunk(n);
        chunk.start = Long.parseLong(hashMap.get("start"));
        chunk.length = Integer.parseInt(hashMap.get("length"));
        chunk.pageCount = Integer.parseInt(hashMap.get("pageCount"));
        chunk.maxLength = Long.parseLong(hashMap.get("maxLength"));
        chunk.maxLengthLive = Long.parseLong(hashMap.get("maxLengthLive"));
        chunk.metaRootPos = Long.parseLong(hashMap.get("metaRoot"));
        chunk.version = Long.parseLong(hashMap.get("version"));
        return chunk;
    }

    public int getFillRate() {
        return (int)(this.maxLength == 0L ? 0L : 100L * this.maxLengthLive / this.maxLength);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object instanceof Chunk && ((Chunk)object).id == this.id;
    }

    public String asString() {
        return "id:" + this.id + "," + "start:" + this.start + "," + "length:" + this.length + "," + "pageCount:" + this.pageCount + "," + "maxLength:" + this.maxLength + "," + "maxLengthLive:" + this.maxLengthLive + "," + "metaRoot:" + this.metaRootPos + "," + "version:" + this.version;
    }
}

