/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.store.FrontEndCacheTier;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.disk.DiskStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiskBackedMemoryStore
extends FrontEndCacheTier<MemoryStore, DiskStore> {
    private DiskBackedMemoryStore(CacheConfiguration cacheConfiguration, MemoryStore cache, DiskStore authority) {
        super(cache, authority, cacheConfiguration.getCopyStrategy(), cacheConfiguration.isCopyOnWrite(), cacheConfiguration.isCopyOnRead());
    }

    public static Store create(Ehcache cache, String diskStorePath, Pool onHeapPool, Pool onDiskPool) {
        MemoryStore memoryStore = DiskBackedMemoryStore.createMemoryStore(cache, onHeapPool);
        DiskStore diskStore = DiskBackedMemoryStore.createDiskStore(cache, diskStorePath, onHeapPool, onDiskPool);
        return new DiskBackedMemoryStore(cache.getCacheConfiguration(), memoryStore, diskStore);
    }

    private static MemoryStore createMemoryStore(Ehcache cache, Pool onHeapPool) {
        return MemoryStore.create(cache, onHeapPool);
    }

    private static DiskStore createDiskStore(Ehcache cache, String diskPath, Pool onHeapPool, Pool onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        if (config.isDiskPersistent() || config.isOverflowToDisk()) {
            return DiskStore.create(cache, diskPath, onHeapPool, onDiskPool);
        }
        throw new CacheException("DiskBackedMemoryStore can only be used when cache overflows to disk or is disk persistent");
    }

    @Override
    public Object getMBean() {
        return null;
    }

    @Override
    public boolean notifyEvictionFromCache(Serializable key) {
        return ((DiskStore)this.authority).cleanUpFailedMarker(key);
    }
}

