/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ResourceStatistics
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public Long mBytes;
    public Long numRecords;
    public Long avgRecordSize;
    public ResourceFieldStatistics[] fields = new ResourceFieldStatistics[0];

    public Long getmBytes() {
        return this.mBytes;
    }

    public ResourceStatistics setmBytes(Long mBytes) {
        this.mBytes = mBytes;
        return this;
    }

    public Long getNumRecords() {
        return this.numRecords;
    }

    public ResourceStatistics setNumRecords(Long numRecords) {
        this.numRecords = numRecords;
        return this;
    }

    public Long getAvgRecordSize() {
        if (this.avgRecordSize == null && this.mBytes != null && this.numRecords != null) {
            return this.mBytes / this.numRecords;
        }
        return this.avgRecordSize;
    }

    public void setAvgRecordSize(Long size) {
        this.avgRecordSize = size;
    }

    public ResourceFieldStatistics[] getFields() {
        return this.fields;
    }

    public ResourceStatistics setFields(ResourceFieldStatistics[] fields) {
        if (fields != null) {
            this.fields = Arrays.copyOf(fields, fields.length);
        }
        return this;
    }

    public boolean equals(Object anOther) {
        if (anOther == null || !anOther.getClass().equals(this.getClass())) {
            return false;
        }
        ResourceStatistics other = (ResourceStatistics)anOther;
        return Arrays.equals(this.fields, other.fields) && (this.mBytes == null ? other.mBytes == null : this.mBytes.equals(other.mBytes)) && (this.numRecords == null ? other.numRecords == null : this.numRecords.equals(other.numRecords));
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + Arrays.hashCode(this.fields);
        hash = 31 * hash + (this.mBytes == null ? 0 : this.mBytes.hashCode());
        hash = 31 * hash + (this.numRecords == null ? 0 : this.numRecords.hashCode());
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Field Stats: \n");
        for (ResourceFieldStatistics f : this.fields) {
            sb.append(f.toString());
        }
        sb.append("mBytes: " + this.mBytes);
        sb.append("numRecords: " + this.numRecords);
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class ResourceFieldStatistics
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public int version;
        public Long numDistinctValues;
        public Object[] mostCommonValues = new Object[0];
        public float[] mostCommonValuesFreq = new float[0];
        public Object[] valueHistogram = new Object[0];

        public int getVersion() {
            return this.version;
        }

        public ResourceFieldStatistics setVersion(int version) {
            this.version = version;
            return this;
        }

        public Long getNumDistinctValues() {
            return this.numDistinctValues;
        }

        public ResourceFieldStatistics setNumDistinctValues(Long numDistinctValues) {
            this.numDistinctValues = numDistinctValues;
            return this;
        }

        public Object[] getMostCommonValues() {
            return this.mostCommonValues;
        }

        public ResourceFieldStatistics setMostCommonValues(Object[] mostCommonValues) {
            if (mostCommonValues != null) {
                this.mostCommonValues = Arrays.copyOf(mostCommonValues, mostCommonValues.length);
            }
            return this;
        }

        public float[] getMostCommonValuesFreq() {
            return this.mostCommonValuesFreq;
        }

        public ResourceFieldStatistics setMostCommonValuesFreq(float[] mostCommonValuesFreq) {
            if (mostCommonValuesFreq != null) {
                this.mostCommonValuesFreq = Arrays.copyOf(mostCommonValuesFreq, mostCommonValuesFreq.length);
            }
            return this;
        }

        public Object[] getValueHistogram() {
            return this.valueHistogram;
        }

        public ResourceFieldStatistics setValueHistogram(Object[] valueHistogram) {
            if (valueHistogram != null) {
                this.valueHistogram = Arrays.copyOf(valueHistogram, valueHistogram.length);
            }
            return this;
        }

        public boolean equals(Object anOther) {
            if (anOther == null || !anOther.getClass().equals(this.getClass())) {
                return false;
            }
            ResourceFieldStatistics other = (ResourceFieldStatistics)anOther;
            return Arrays.equals(this.mostCommonValues, other.mostCommonValues) && Arrays.equals(this.mostCommonValuesFreq, other.mostCommonValuesFreq) && Arrays.equals(this.valueHistogram, other.valueHistogram) && this.numDistinctValues.equals(other.numDistinctValues) && this.version == other.version;
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + Arrays.hashCode(this.mostCommonValues);
            hash = 31 * hash + Arrays.hashCode(this.mostCommonValuesFreq);
            hash = 31 * hash + this.numDistinctValues.hashCode();
            hash = 31 * hash + Arrays.hashCode(this.valueHistogram);
            hash = 31 * hash + this.version;
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ResourceStatistics. Version: " + this.version + "\n");
            sb.append("MCV:\n");
            for (Object o : this.mostCommonValues) {
                sb.append('[' + o.toString() + ']');
            }
            sb.append("\n MCVfreq:\n");
            float[] fArray = this.mostCommonValuesFreq;
            int len$ = fArray.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Float f = Float.valueOf(fArray[i$]);
                sb.append('[' + f.toString() + ']');
            }
            sb.append("\n");
            sb.append("numDistVals: " + this.numDistinctValues);
            sb.append("valHistogram: \n");
            for (Object o : this.valueHistogram) {
                sb.append('[' + o.toString() + ']');
            }
            sb.append("\n");
            return sb.toString();
        }
    }
}

