/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.Stack;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;

public abstract class PlanVisitor {
    protected static final String DEFAULT_SCOPE = "scope";
    protected OperatorPlan plan;
    protected PlanWalker currentWalker;
    private Stack<PlanWalker> walkers;

    public void visit() throws FrontendException {
        this.currentWalker.walk(this);
    }

    public OperatorPlan getPlan() {
        return this.plan;
    }

    protected PlanVisitor(OperatorPlan plan, PlanWalker walker) {
        this.plan = plan;
        this.currentWalker = walker;
        this.walkers = new Stack();
    }

    protected void pushWalker(PlanWalker walker) {
        this.walkers.push(this.currentWalker);
        this.currentWalker = walker;
    }

    protected void popWalker() throws FrontendException {
        if (this.walkers.empty()) {
            throw new FrontendException("No more walkers to pop.", 2221);
        }
        this.currentWalker = this.walkers.pop();
    }
}

