/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.Map;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.visitor.LineageFindRelVisitor;

public class CastLineageSetter
extends AllExpressionVisitor {
    private CompilationMessageCollector msgCollector;
    private Map<Long, FuncSpec> uid2LoadFuncMap;

    public CastLineageSetter(LogicalPlan plan, CompilationMessageCollector msgCollector) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
        this.msgCollector = msgCollector;
        LineageFindRelVisitor lineageFinder = new LineageFindRelVisitor(plan);
        lineageFinder.visit();
        this.uid2LoadFuncMap = lineageFinder.getUid2LoadFuncMap();
    }

    protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan exprPlan) throws FrontendException {
        return new CastLineageSetterExpVisitor(exprPlan, this.uid2LoadFuncMap, this.msgCollector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CastLineageSetterExpVisitor
    extends LogicalExpressionVisitor {
        private Map<Long, FuncSpec> uid2LoadFuncMap;
        private CompilationMessageCollector msgCollector;

        protected CastLineageSetterExpVisitor(OperatorPlan expPlan, Map<Long, FuncSpec> uid2LoadFuncMap, CompilationMessageCollector msgCollector) throws FrontendException {
            super(expPlan, new ReverseDependencyOrderWalker(expPlan));
            this.uid2LoadFuncMap = uid2LoadFuncMap;
            this.msgCollector = msgCollector;
        }

        @Override
        public void visit(CastExpression cast) throws FrontendException {
            byte inType = cast.getExpression().getType();
            byte outType = cast.getType();
            if (this.containsByteArrayOrEmtpyInSchema(cast.getExpression().getFieldSchema())) {
                long inUid = cast.getExpression().getFieldSchema().uid;
                FuncSpec inLoadFunc = this.uid2LoadFuncMap.get(inUid);
                if (inLoadFunc == null) {
                    String msg = "Cannot resolve load function to use for casting from " + DataType.findTypeName(inType) + " to " + DataType.findTypeName(outType) + ". ";
                    this.msgCollector.collect(msg, CompilationMessageCollector.MessageType.Warning);
                } else {
                    cast.setFuncSpec(inLoadFunc);
                }
            }
        }

        private boolean containsByteArrayOrEmtpyInSchema(LogicalSchema.LogicalFieldSchema fs) throws FrontendException {
            if (fs.type == 50) {
                return true;
            }
            if (DataType.isAtomic(fs.type)) {
                return false;
            }
            if (fs.schema == null || fs.schema.size() == 0) {
                return true;
            }
            for (LogicalSchema.LogicalFieldSchema inFs : fs.schema.getFields()) {
                if (!this.containsByteArrayOrEmtpyInSchema(inFs)) continue;
                return true;
            }
            return false;
        }
    }
}

