/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.parser.ParserException;

public class StreamingCommandUtils {
    private static final String PERL = "perl";
    private static final String PYTHON = "python";
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private final PigContext pigContext;

    public StreamingCommandUtils(PigContext pigContext) {
        this.pigContext = pigContext;
    }

    /*
     * Unable to fully structure code
     */
    static String[] splitArgs(String command) throws ParserException {
        argv = new ArrayList<String>();
        beginIndex = 0;
        endIndex = -1;
        while (beginIndex < command.length()) {
            block6: {
                arg = "";
                while (Character.isWhitespace(command.charAt(beginIndex))) {
                    ++beginIndex;
                }
                delim = 32;
                charAtIndex = command.charAt(beginIndex);
                if (charAtIndex != '\'' && charAtIndex != '\"') break block6;
                delim = charAtIndex;
                ** GOTO lbl-1000
            }
            for (endIndex = beginIndex + 1; endIndex < command.length() && (charAtEndIdx = command.charAt(endIndex)) != ' '; ++endIndex) {
                if (charAtEndIdx != '\'' && charAtEndIdx != '\"') continue;
                arg = command.substring(beginIndex, endIndex);
                beginIndex = endIndex;
                endIndex = beginIndex + 1;
                delim = charAtEndIdx;
                break;
            }
            if (delim == 32) {
                argv.add(command.substring(beginIndex, endIndex));
            } else lbl-1000:
            // 2 sources

            {
                endIndex = command.indexOf(delim, endIndex);
                if (endIndex == -1) {
                    throw new ParserException("Illegal command: " + command);
                }
                argv.add(arg + command.substring(beginIndex, endIndex + 1));
            }
            beginIndex = endIndex + 1;
        }
        return argv.toArray(new String[argv.size()]);
    }

    void checkAutoShipSpecs(StreamingCommand command, String[] argv) throws ParserException {
        String arg0 = argv[0];
        if (arg0.equalsIgnoreCase(PERL) || arg0.equalsIgnoreCase(PYTHON)) {
            for (int i = 1; i < argv.length; ++i) {
                if (argv[i].startsWith("-") || StreamingCommandUtils.isQuotedString(argv[i])) continue;
                this.checkAndShip(command, argv[i]);
                break;
            }
        } else {
            this.checkAndShip(command, arg0);
        }
    }

    private void checkAndShip(StreamingCommand command, String arg) throws ParserException {
        if (arg.startsWith("/")) {
            return;
        }
        String argPath = StreamingCommandUtils.which(arg);
        if (argPath != null && !this.inSkipPaths(argPath)) {
            try {
                command.addPathToShip(argPath);
            }
            catch (IOException e) {
                ParserException pe = new ParserException(e.getMessage());
                pe.initCause(e);
                throw pe;
            }
        }
    }

    private static boolean isQuotedString(String s) {
        return s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'';
    }

    private boolean inSkipPaths(String file) {
        for (String skipPath : this.pigContext.getPathsToSkip()) {
            if (!file.startsWith(skipPath)) continue;
            return true;
        }
        return false;
    }

    private static String which(String file) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("which", file);
            Process process = processBuilder.start();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String fullPath = stdout.readLine();
            return process.waitFor() == 0 ? fullPath : null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

