/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.Status;
import azkaban.flow.Node;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutableNode {
    private String jobId;
    private int executionId;
    private String type;
    private String jobPropsSource;
    private String inheritPropsSource;
    private Status status = Status.READY;
    private long startTime = -1L;
    private long endTime = -1L;
    private long updateTime = -1L;
    private int level = 0;
    private ExecutableFlow flow;
    private Props outputProps;
    private int attempt = 0;
    private boolean paused = false;
    private long delayExecution = 0L;
    private Set<String> inNodes = new HashSet<String>();
    private Set<String> outNodes = new HashSet<String>();
    private Integer externalExecutionId;
    private ArrayList<Attempt> pastAttempts = null;

    public ExecutableNode(Node node, ExecutableFlow flow) {
        this.jobId = node.getId();
        this.executionId = flow.getExecutionId();
        this.type = node.getType();
        this.jobPropsSource = node.getJobSource();
        this.inheritPropsSource = node.getPropsSource();
        this.status = Status.READY;
        this.level = node.getLevel();
        this.flow = flow;
    }

    public ExecutableNode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForRetry() {
        Attempt pastAttempt = new Attempt(this.attempt, this.startTime, this.endTime, this.status);
        ++this.attempt;
        ExecutableNode executableNode = this;
        synchronized (executableNode) {
            if (this.pastAttempts == null) {
                this.pastAttempts = new ArrayList();
            }
            this.pastAttempts.add(pastAttempt);
        }
        this.startTime = -1L;
        this.endTime = -1L;
        this.updateTime = System.currentTimeMillis();
        this.status = Status.READY;
    }

    public void setExecutableFlow(ExecutableFlow flow) {
        this.flow = flow;
    }

    public void setExecutionId(int id) {
        this.executionId = id;
    }

    public int getExecutionId() {
        return this.executionId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String id) {
        this.jobId = id;
    }

    public void addInNode(String exNode) {
        this.inNodes.add(exNode);
    }

    public void addOutNode(String exNode) {
        this.outNodes.add(exNode);
    }

    public Set<String> getOutNodes() {
        return this.outNodes;
    }

    public Set<String> getInNodes() {
        return this.inNodes;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getDelayedExecution() {
        return this.delayExecution;
    }

    public void setDelayedExecution(long delayMs) {
        this.delayExecution = delayMs;
    }

    public Object toObject() {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put("id", this.jobId);
        objMap.put("jobSource", this.jobPropsSource);
        objMap.put("propSource", this.inheritPropsSource);
        objMap.put("jobType", this.type);
        objMap.put("status", this.status.toString());
        objMap.put("inNodes", new ArrayList<String>(this.inNodes));
        objMap.put("outNodes", new ArrayList<String>(this.outNodes));
        objMap.put("startTime", this.startTime);
        objMap.put("endTime", this.endTime);
        objMap.put("updateTime", this.updateTime);
        objMap.put("level", this.level);
        objMap.put("externalExecutionId", this.externalExecutionId);
        objMap.put("paused", this.paused);
        if (this.pastAttempts != null) {
            ArrayList<Map<String, Object>> attemptsList = new ArrayList<Map<String, Object>>(this.pastAttempts.size());
            for (Attempt attempts : this.pastAttempts) {
                attemptsList.add(attempts.toObject());
            }
            objMap.put("pastAttempts", attemptsList);
        }
        return objMap;
    }

    public static ExecutableNode createNodeFromObject(Object obj, ExecutableFlow flow) {
        List pastAttempts;
        ExecutableNode exNode = new ExecutableNode();
        HashMap objMap = (HashMap)obj;
        exNode.executionId = flow == null ? 0 : flow.getExecutionId();
        exNode.jobId = (String)objMap.get("id");
        exNode.jobPropsSource = (String)objMap.get("jobSource");
        exNode.inheritPropsSource = (String)objMap.get("propSource");
        exNode.type = (String)objMap.get("jobType");
        exNode.status = Status.valueOf((String)objMap.get("status"));
        exNode.inNodes.addAll((List)objMap.get("inNodes"));
        exNode.outNodes.addAll((List)objMap.get("outNodes"));
        exNode.startTime = JSONUtils.getLongFromObject(objMap.get("startTime"));
        exNode.endTime = JSONUtils.getLongFromObject(objMap.get("endTime"));
        exNode.updateTime = JSONUtils.getLongFromObject(objMap.get("updateTime"));
        exNode.level = (Integer)objMap.get("level");
        exNode.externalExecutionId = (Integer)objMap.get("externalExecutionId");
        exNode.flow = flow;
        Boolean paused = (Boolean)objMap.get("paused");
        if (paused != null) {
            exNode.paused = paused;
        }
        if ((pastAttempts = (List)objMap.get("pastAttempts")) != null) {
            ArrayList<Attempt> attempts = new ArrayList<Attempt>();
            for (Object attemptObj : pastAttempts) {
                Attempt attempt = Attempt.fromObject(attemptObj);
                attempts.add(attempt);
            }
            exNode.pastAttempts = attempts;
        }
        return exNode;
    }

    public void updateNodeFromObject(Object obj) {
        HashMap objMap = (HashMap)obj;
        this.status = Status.valueOf((String)objMap.get("status"));
        this.startTime = JSONUtils.getLongFromObject(objMap.get("startTime"));
        this.endTime = JSONUtils.getLongFromObject(objMap.get("endTime"));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getJobPropsSource() {
        return this.jobPropsSource;
    }

    public String getPropsSource() {
        return this.inheritPropsSource;
    }

    public int getLevel() {
        return this.level;
    }

    public ExecutableFlow getFlow() {
        return this.flow;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setOutputProps(Props output) {
        this.outputProps = output;
    }

    public Props getOutputProps() {
        return this.outputProps;
    }

    public Integer getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public void setExternalExecutionId(Integer externalExecutionId) {
        this.externalExecutionId = externalExecutionId;
    }

    public List<Attempt> getPastAttemptList() {
        return this.pastAttempts;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public List<Object> getAttemptObjects() {
        ArrayList<Object> array = new ArrayList<Object>();
        for (Attempt attempt : this.pastAttempts) {
            array.add(attempt.toObject());
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePastAttempts(List<Object> pastAttemptsList) {
        if (pastAttemptsList == null) {
            return;
        }
        ExecutableNode executableNode = this;
        synchronized (executableNode) {
            if (this.pastAttempts == null) {
                this.pastAttempts = new ArrayList();
            }
            if (pastAttemptsList.size() <= this.pastAttempts.size()) {
                return;
            }
            Object[] pastAttemptArray = pastAttemptsList.toArray();
            for (int i = this.pastAttempts.size(); i < pastAttemptArray.length; ++i) {
                Attempt attempt = Attempt.fromObject(pastAttemptArray[i]);
                this.pastAttempts.add(attempt);
            }
        }
    }

    public static class Attempt {
        private int attempt = 0;
        private long startTime = -1L;
        private long endTime = -1L;
        private Status status;

        public Attempt(int attempt, long startTime, long endTime, Status status) {
            this.attempt = attempt;
            this.startTime = startTime;
            this.endTime = endTime;
            this.status = status;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public Status getStatus() {
            return this.status;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public static Attempt fromObject(Object obj) {
            Map map = (Map)obj;
            int attempt = (Integer)map.get("attempt");
            long startTime = JSONUtils.getLongFromObject(map.get("startTime"));
            long endTime = JSONUtils.getLongFromObject(map.get("endTime"));
            Status status = Status.valueOf((String)map.get("status"));
            return new Attempt(attempt, startTime, endTime, status);
        }

        public Map<String, Object> toObject() {
            HashMap<String, Object> attempts = new HashMap<String, Object>();
            attempts.put("attempt", this.attempt);
            attempts.put("startTime", this.startTime);
            attempts.put("endTime", this.endTime);
            attempts.put("status", this.status.toString());
            return attempts;
        }
    }
}

