/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.execapp.ExecutorServlet;
import azkaban.execapp.FlowRunnerManager;
import azkaban.execapp.JMXHttpServlet;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.jmx.JmxFlowRunnerManager;
import azkaban.jmx.JmxJettyServer;
import azkaban.project.JdbcProjectLoader;
import azkaban.project.ProjectLoader;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class AzkabanExecutorServer {
    private static final Logger logger = Logger.getLogger(AzkabanExecutorServer.class);
    private static final int MAX_FORM_CONTENT_SIZE = 0xA00000;
    public static final String AZKABAN_HOME = "AZKABAN_HOME";
    public static final String DEFAULT_CONF_PATH = "conf";
    public static final String AZKABAN_PROPERTIES_FILE = "azkaban.properties";
    public static final String AZKABAN_PRIVATE_PROPERTIES_FILE = "azkaban.private.properties";
    public static final String JOBTYPE_PLUGIN_DIR = "azkaban.jobtype.plugin.dir";
    public static final int DEFAULT_PORT_NUMBER = 12321;
    private static final String DEFAULT_TIMEZONE_ID = "default.timezone.id";
    private static final int DEFAULT_THREAD_NUMBER = 50;
    private static AzkabanExecutorServer app;
    private ExecutorLoader executionLoader;
    private ProjectLoader projectLoader;
    private FlowRunnerManager runnerManager;
    private Props props;
    private Props executorGlobalProps;
    private Server server;
    private ArrayList<ObjectName> registeredMBeans = new ArrayList();
    private MBeanServer mbeanServer;

    public AzkabanExecutorServer(Props props) throws Exception {
        this.props = props;
        int portNumber = props.getInt("executor.port", 12321);
        int maxThreads = props.getInt("executor.maxThreads", 50);
        this.server = new Server(portNumber);
        QueuedThreadPool httpThreadPool = new QueuedThreadPool(maxThreads);
        this.server.setThreadPool((ThreadPool)httpThreadPool);
        Context root = new Context((HandlerContainer)this.server, "/", 1);
        root.setMaxFormContentSize(0xA00000);
        root.addServlet(new ServletHolder((Servlet)new ExecutorServlet()), "/executor");
        root.addServlet(new ServletHolder((Servlet)new JMXHttpServlet()), "/jmx");
        root.setAttribute("azkaban_app", (Object)this);
        this.executionLoader = this.createExecLoader(props);
        this.projectLoader = this.createProjectLoader(props);
        this.runnerManager = new FlowRunnerManager(props, this.executionLoader, this.projectLoader, this.getClass().getClassLoader());
        String globalPropsPath = props.getString("executor.global.properties", null);
        this.executorGlobalProps = globalPropsPath == null ? new Props() : new Props(null, globalPropsPath);
        this.runnerManager.setGlobalProps(this.executorGlobalProps);
        this.configureMBeanServer();
        try {
            this.server.start();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            Utils.croak(e.getMessage(), 1);
        }
        logger.info((Object)("Azkaban Executor Server started on port " + portNumber));
    }

    private ExecutorLoader createExecLoader(Props props) {
        return new JdbcExecutorLoader(props);
    }

    private ProjectLoader createProjectLoader(Props props) {
        return new JdbcProjectLoader(props);
    }

    public void stopServer() throws Exception {
        this.server.stop();
        this.server.destroy();
    }

    public ProjectLoader getProjectLoader() {
        return this.projectLoader;
    }

    public ExecutorLoader getExecutorLoader() {
        return this.executionLoader;
    }

    public Props getAzkabanProps() {
        return this.props;
    }

    public Props getExecutorGlobalProps() {
        return this.executorGlobalProps;
    }

    public static void main(String[] args) throws Exception {
        logger.error((Object)"Starting Jetty Azkaban Executor...");
        Props azkabanSettings = AzkabanServer.loadProps(args);
        if (azkabanSettings == null) {
            logger.error((Object)"Azkaban Properties not loaded.");
            logger.error((Object)"Exiting Azkaban Executor Server...");
            return;
        }
        if (azkabanSettings.containsKey(DEFAULT_TIMEZONE_ID)) {
            String timezone = azkabanSettings.getString(DEFAULT_TIMEZONE_ID);
            TimeZone.setDefault(TimeZone.getTimeZone(timezone));
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)timezone));
            logger.info((Object)("Setting timezone to " + timezone));
        }
        app = new AzkabanExecutorServer(azkabanSettings);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info((Object)"Shutting down http server...");
                try {
                    app.stopServer();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while shutting down http server.", (Throwable)e);
                }
                logger.info((Object)"kk thx bye.");
            }
        });
    }

    static Props loadConfigurationFromAzkabanHome() {
        String azkabanHome = System.getenv(AZKABAN_HOME);
        if (azkabanHome == null) {
            logger.error((Object)"AZKABAN_HOME not set. Will try default.");
            return null;
        }
        if (!new File(azkabanHome).isDirectory() || !new File(azkabanHome).canRead()) {
            logger.error((Object)(azkabanHome + " is not a readable directory."));
            return null;
        }
        File confPath = new File(azkabanHome, DEFAULT_CONF_PATH);
        if (!(confPath.exists() && confPath.isDirectory() && confPath.canRead())) {
            logger.error((Object)(azkabanHome + " does not contain a readable conf directory."));
            return null;
        }
        return AzkabanExecutorServer.loadAzkabanConfigurationFromDirectory(confPath);
    }

    public FlowRunnerManager getFlowRunnerManager() {
        return this.runnerManager;
    }

    private static Props loadAzkabanConfigurationFromDirectory(File dir) {
        File azkabanPrivatePropsFile = new File(dir, AZKABAN_PRIVATE_PROPERTIES_FILE);
        File azkabanPropsFile = new File(dir, AZKABAN_PROPERTIES_FILE);
        Props props = null;
        try {
            if (azkabanPrivatePropsFile.exists() && azkabanPrivatePropsFile.isFile()) {
                logger.info((Object)"Loading azkaban private properties file");
                props = new Props(null, azkabanPrivatePropsFile);
            }
            if (azkabanPropsFile.exists() && azkabanPropsFile.isFile()) {
                logger.info((Object)"Loading azkaban properties file");
                props = new Props(props, azkabanPropsFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"File not found. Could not load azkaban config file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"File found, but error reading. Could not load azkaban config file", (Throwable)e);
        }
        return props;
    }

    private void configureMBeanServer() {
        logger.info((Object)"Registering MBeans...");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.registerMbean("executorJetty", new JmxJettyServer(this.server));
        this.registerMbean("flowRunnerManager", new JmxFlowRunnerManager(this.runnerManager));
    }

    public void close() {
        try {
            for (ObjectName name : this.registeredMBeans) {
                this.mbeanServer.unregisterMBean(name);
                logger.info((Object)("Jmx MBean " + name.getCanonicalName() + " unregistered."));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to cleanup MBeanServer", (Throwable)e);
        }
    }

    private void registerMbean(String name, Object mbean) {
        Class<?> mbeanClass = mbean.getClass();
        try {
            ObjectName mbeanName = new ObjectName(mbeanClass.getName() + ":name=" + name);
            this.mbeanServer.registerMBean(mbean, mbeanName);
            logger.info((Object)("Bean " + mbeanClass.getCanonicalName() + " registered."));
            this.registeredMBeans.add(mbeanName);
        }
        catch (Exception e) {
            logger.error((Object)("Error registering mbean " + mbeanClass.getCanonicalName()), (Throwable)e);
        }
    }

    public List<ObjectName> getMbeanNames() {
        return this.registeredMBeans;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) {
        try {
            return this.mbeanServer.getMBeanInfo(name);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public Object getMBeanAttribute(ObjectName name, String attribute) {
        try {
            return this.mbeanServer.getAttribute(name, attribute);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }
}

