/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor;

import azkaban.jobExecutor.AbstractJob;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class AbstractProcessJob
extends AbstractJob {
    private final Logger log;
    public static final String ENV_PREFIX = "env.";
    public static final String ENV_PREFIX_UCASE = "ENV.";
    public static final String WORKING_DIR = "working.dir";
    public static final String JOB_PROP_ENV = "JOB_PROP_FILE";
    public static final String JOB_NAME_ENV = "JOB_NAME";
    public static final String JOB_OUTPUT_PROP_FILE = "JOB_OUTPUT_PROP_FILE";
    protected final String _jobPath;
    protected volatile Props jobProps;
    protected volatile Props sysProps;
    protected String _cwd;
    private volatile Props generatedPropeties;

    protected AbstractProcessJob(String jobid, Props sysProps, Props jobProps, Logger log) {
        super(jobid, log);
        this.jobProps = jobProps;
        this.sysProps = sysProps;
        this._jobPath = this._cwd = this.getWorkingDirectory();
        this.log = log;
    }

    public Props getJobProps() {
        return this.jobProps;
    }

    public Props getSysProps() {
        return this.sysProps;
    }

    public String getJobPath() {
        return this._jobPath;
    }

    protected void resolveProps() {
        this.jobProps = PropsUtils.resolveProps(this.jobProps);
    }

    @Override
    public Props getJobGeneratedProperties() {
        return this.generatedPropeties;
    }

    public File[] initPropsFiles() {
        File[] files = new File[2];
        files[0] = this.createFlattenedPropsFile(this._cwd);
        this.jobProps.put("env.JOB_PROP_FILE", files[0].getAbsolutePath());
        this.jobProps.put("env.JOB_NAME", this.getId());
        files[1] = AbstractProcessJob.createOutputPropsFile(this.getId(), this._cwd);
        this.jobProps.put("env.JOB_OUTPUT_PROP_FILE", files[1].getAbsolutePath());
        return files;
    }

    public String getCwd() {
        return this._cwd;
    }

    public Map<String, String> getEnvironmentVariables() {
        Props props = this.getJobProps();
        Map<String, String> envMap = props.getMapByPrefix(ENV_PREFIX);
        envMap.putAll(props.getMapByPrefix(ENV_PREFIX_UCASE));
        return envMap;
    }

    public String getWorkingDirectory() {
        String workingDir = this.getJobProps().getString(WORKING_DIR, this._jobPath);
        if (workingDir == null) {
            return "";
        }
        return workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Props loadOutputFileProps(File outputPropertiesFile) {
        BufferedInputStream reader = null;
        try {
            System.err.println("output properties file=" + outputPropertiesFile.getAbsolutePath());
            reader = new BufferedInputStream(new FileInputStream(outputPropertiesFile));
            Props outputProps = new Props();
            String content = Streams.asString((InputStream)reader).trim();
            if (!content.isEmpty()) {
                Map propMap = (Map)JSONUtils.parseJSONFromString(content);
                for (Map.Entry entry : propMap.entrySet()) {
                    outputProps.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
            Props props = outputProps;
            IOUtils.closeQuietly((InputStream)reader);
            return props;
        }
        catch (FileNotFoundException e) {
            this.log.info((Object)String.format("File[%s] wasn't found, returning empty props.", outputPropertiesFile));
            Props props = new Props();
            IOUtils.closeQuietly((InputStream)reader);
            return props;
        }
        catch (Exception e2) {
            this.log.error((Object)"Exception thrown when trying to load output file props.  Returning empty Props instead of failing.  Is this really the best thing to do?", (Throwable)e2);
            Props props = new Props();
            return props;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public File createFlattenedPropsFile(String workingDir) {
        File directory = new File(workingDir);
        File tempFile = null;
        try {
            tempFile = File.createTempFile(this.getId() + "_", "_tmp", directory);
            this.jobProps.storeFlattened(tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp property file ", e);
        }
        return tempFile;
    }

    public static File createOutputPropsFile(String id, String workingDir) {
        System.err.println("cwd=" + workingDir);
        File directory = new File(workingDir);
        File tempFile = null;
        try {
            tempFile = File.createTempFile(id + "_output_", "_tmp", directory);
        }
        catch (IOException e) {
            System.err.println("Failed to create temp output property file :\n");
            e.printStackTrace(System.err);
            throw new RuntimeException("Failed to create temp output property file ", e);
        }
        return tempFile;
    }

    public void generateProperties(File outputFile) {
        this.generatedPropeties = this.loadOutputFileProps(outputFile);
    }
}

