/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CircularBuffer<T>
implements Iterable<T> {
    private final List<T> lines = new ArrayList<T>();
    private final int size;
    private int start;

    public CircularBuffer(int size) {
        this.size = size;
        this.start = 0;
    }

    public void append(T line) {
        if (this.lines.size() < this.size) {
            this.lines.add(line);
        } else {
            this.lines.set(this.start, line);
            this.start = (this.start + 1) % this.size;
        }
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.lines) + "]";
    }

    @Override
    public Iterator<T> iterator() {
        if (this.start == 0) {
            return this.lines.iterator();
        }
        return Iterators.concat(this.lines.subList(this.start, this.lines.size()).iterator(), this.lines.subList(0, this.start).iterator());
    }

    public int getMaxSize() {
        return this.size;
    }

    public int getSize() {
        return this.lines.size();
    }
}

