/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.utils.cache;

import azkaban.utils.cache.Cache;
import azkaban.utils.cache.CacheManager;
import org.junit.Assert;
import org.junit.Test;

public class CacheTest {
    @Test
    public void testLRU() {
        CacheManager manager = CacheManager.getInstance();
        Cache cache = manager.createCache();
        cache.setEjectionPolicy(Cache.EjectionPolicy.LRU);
        cache.setMaxCacheSize(4);
        cache.insertElement((Object)"key1", (Object)"val1");
        cache.insertElement((Object)"key2", (Object)"val2");
        cache.insertElement((Object)"key3", (Object)"val3");
        cache.insertElement((Object)"key4", (Object)"val4");
        Assert.assertEquals((Object)cache.get((Object)"key2"), (Object)"val2");
        Assert.assertEquals((Object)cache.get((Object)"key3"), (Object)"val3");
        Assert.assertEquals((Object)cache.get((Object)"key4"), (Object)"val4");
        Assert.assertEquals((Object)cache.get((Object)"key1"), (Object)"val1");
        Assert.assertEquals((long)4L, (long)cache.getSize());
        cache.insertElement((Object)"key5", (Object)"val5");
        Assert.assertEquals((long)4L, (long)cache.getSize());
        Assert.assertEquals((Object)cache.get((Object)"key3"), (Object)"val3");
        Assert.assertEquals((Object)cache.get((Object)"key4"), (Object)"val4");
        Assert.assertEquals((Object)cache.get((Object)"key1"), (Object)"val1");
        Assert.assertEquals((Object)cache.get((Object)"key5"), (Object)"val5");
        Assert.assertNull((Object)cache.get((Object)"key2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFIFO() {
        CacheManager manager = CacheManager.getInstance();
        Cache cache = manager.createCache();
        cache.setEjectionPolicy(Cache.EjectionPolicy.FIFO);
        cache.setMaxCacheSize(4);
        cache.insertElement((Object)"key1", (Object)"val1");
        CacheTest cacheTest = this;
        synchronized (cacheTest) {
            try {
                this.wait(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        cache.insertElement((Object)"key2", (Object)"val2");
        cache.insertElement((Object)"key3", (Object)"val3");
        cache.insertElement((Object)"key4", (Object)"val4");
        Assert.assertEquals((Object)cache.get((Object)"key2"), (Object)"val2");
        Assert.assertEquals((Object)cache.get((Object)"key3"), (Object)"val3");
        Assert.assertEquals((Object)cache.get((Object)"key4"), (Object)"val4");
        Assert.assertEquals((Object)cache.get((Object)"key1"), (Object)"val1");
        Assert.assertEquals((long)4L, (long)cache.getSize());
        cache.insertElement((Object)"key5", (Object)"val5");
        Assert.assertEquals((long)4L, (long)cache.getSize());
        Assert.assertEquals((Object)cache.get((Object)"key3"), (Object)"val3");
        Assert.assertEquals((Object)cache.get((Object)"key4"), (Object)"val4");
        Assert.assertEquals((Object)cache.get((Object)"key2"), (Object)"val2");
        Assert.assertEquals((Object)cache.get((Object)"key5"), (Object)"val5");
        Assert.assertNull((Object)cache.get((Object)"key1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeToLiveExpiry() {
        CacheManager.setUpdateFrequency((long)200L);
        CacheManager manager = CacheManager.getInstance();
        Cache cache = manager.createCache();
        cache.setUpdateFrequencyMs(200L);
        cache.setEjectionPolicy(Cache.EjectionPolicy.FIFO);
        cache.setExpiryTimeToLiveMs(4500L);
        cache.insertElement((Object)"key1", (Object)"val1");
        CacheTest cacheTest = this;
        synchronized (cacheTest) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((Object)cache.get((Object)"key1"), (Object)"val1");
        cache.insertElement((Object)"key2", (Object)"val2");
        cacheTest = this;
        synchronized (cacheTest) {
            try {
                this.wait(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertNull((Object)cache.get((Object)"key1"));
        Assert.assertEquals((Object)"val2", (Object)cache.get((Object)"key2"));
        cacheTest = this;
        synchronized (cacheTest) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertNull((Object)cache.get((Object)"key2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdleExpireExpiry() {
        CacheManager.setUpdateFrequency((long)250L);
        CacheManager manager = CacheManager.getInstance();
        Cache cache = manager.createCache();
        cache.setUpdateFrequencyMs(250L);
        cache.setEjectionPolicy(Cache.EjectionPolicy.FIFO);
        cache.setExpiryIdleTimeMs(4500L);
        cache.insertElement((Object)"key1", (Object)"val1");
        cache.insertElement((Object)"key3", (Object)"val3");
        CacheTest cacheTest = this;
        synchronized (cacheTest) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((Object)cache.get((Object)"key1"), (Object)"val1");
        cache.insertElement((Object)"key2", (Object)"val2");
        cacheTest = this;
        synchronized (cacheTest) {
            try {
                this.wait(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((Object)"val1", (Object)cache.get((Object)"key1"));
        Assert.assertNull((Object)cache.get((Object)"key3"));
        cacheTest = this;
        synchronized (cacheTest) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertNull((Object)cache.get((Object)"key2"));
    }
}

