/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.util.UUID;
import javax.transaction.xa.Xid;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.terracotta.TerracottaClient;
import net.sf.ehcache.transaction.TransactionID;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.TransactionIDFactoryImpl;
import net.sf.ehcache.transaction.xa.XidTransactionID;

public class DelegatingTransactionIDFactory
implements TransactionIDFactory {
    private final TerracottaClient terracottaClient;
    private volatile ClusteredInstanceFactory clusteredInstanceFactory;
    private volatile TransactionIDFactory transactionIDFactory;

    public DelegatingTransactionIDFactory(TerracottaClient terracottaClient) {
        this.terracottaClient = terracottaClient;
    }

    private TransactionIDFactory get() {
        ClusteredInstanceFactory cif = this.terracottaClient.getClusteredInstanceFactory();
        if (cif != null && cif != this.clusteredInstanceFactory) {
            this.transactionIDFactory = cif.createTransactionIDFactory(UUID.randomUUID().toString());
            this.clusteredInstanceFactory = cif;
        }
        if (this.transactionIDFactory == null) {
            this.transactionIDFactory = new TransactionIDFactoryImpl();
        }
        return this.transactionIDFactory;
    }

    public TransactionID createTransactionID() {
        return this.get().createTransactionID();
    }

    public XidTransactionID createXidTransactionID(Xid xid) {
        return this.get().createXidTransactionID(xid);
    }
}

