/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.sla.SlaOption;
import azkaban.trigger.ConditionChecker;
import azkaban.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlaChecker
implements ConditionChecker {
    private static final Logger logger = Logger.getLogger(SlaChecker.class);
    public static final String type = "SlaChecker";
    private String id;
    private SlaOption slaOption;
    private int execId;
    private long checkTime = -1L;
    private static ExecutorManagerAdapter executorManager;

    public SlaChecker(String id, SlaOption slaOption, int execId) {
        this.id = id;
        this.slaOption = slaOption;
        this.execId = execId;
    }

    public static void setExecutorManager(ExecutorManagerAdapter em) {
        executorManager = em;
    }

    private Boolean isSlaMissed(ExecutableFlow flow) {
        String type = this.slaOption.getType();
        logger.info((Object)("flow is " + flow.getStatus()));
        if (flow.getStartTime() < 0L) {
            return Boolean.FALSE;
        }
        if (type.equals("FlowFinish")) {
            if (this.checkTime < flow.getStartTime()) {
                ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(flow.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = flow.getStatus();
            if (this.checkTime < DateTime.now().getMillis()) {
                return !this.isFlowFinished(status);
            }
        } else {
            if (type.equals("FlowSucceed")) {
                if (this.checkTime < flow.getStartTime()) {
                    ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                    DateTime startTime = new DateTime(flow.getStartTime());
                    DateTime nextCheckTime = startTime.plus(duration);
                    this.checkTime = nextCheckTime.getMillis();
                }
                Status status = flow.getStatus();
                if (this.checkTime < DateTime.now().getMillis()) {
                    return !this.isFlowSucceeded(status);
                }
                if (!status.equals((Object)Status.FAILED) && !status.equals((Object)Status.KILLED)) {
                    return false;
                }
                return true;
            }
            if (type.equals("JobFinish")) {
                String jobName = (String)this.slaOption.getInfo().get("JobName");
                ExecutableNode node = flow.getExecutableNode(jobName);
                if (node.getStartTime() < 0L) {
                    return Boolean.FALSE;
                }
                if (this.checkTime < node.getStartTime()) {
                    ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                    DateTime startTime = new DateTime(node.getStartTime());
                    DateTime nextCheckTime = startTime.plus(duration);
                    this.checkTime = nextCheckTime.getMillis();
                }
                Status status = node.getStatus();
                if (this.checkTime < DateTime.now().getMillis()) {
                    return !this.isJobFinished(status);
                }
            } else if (type.equals("JobSucceed")) {
                String jobName = (String)this.slaOption.getInfo().get("JobName");
                ExecutableNode node = flow.getExecutableNode(jobName);
                if (node.getStartTime() < 0L) {
                    return Boolean.FALSE;
                }
                if (this.checkTime < node.getStartTime()) {
                    ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                    DateTime startTime = new DateTime(node.getStartTime());
                    DateTime nextCheckTime = startTime.plus(duration);
                    this.checkTime = nextCheckTime.getMillis();
                }
                Status status = node.getStatus();
                if (this.checkTime < DateTime.now().getMillis()) {
                    return !this.isJobFinished(status);
                }
                if (!status.equals((Object)Status.FAILED) && !status.equals((Object)Status.KILLED)) {
                    return false;
                }
                return true;
            }
        }
        return Boolean.FALSE;
    }

    private Boolean isSlaGood(ExecutableFlow flow) {
        String type = this.slaOption.getType();
        logger.info((Object)("flow is " + flow.getStatus()));
        if (flow.getStartTime() < 0L) {
            return Boolean.FALSE;
        }
        if (type.equals("FlowFinish")) {
            if (this.checkTime < flow.getStartTime()) {
                ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(flow.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = flow.getStatus();
            return this.isFlowFinished(status);
        }
        if (type.equals("FlowSucceed")) {
            if (this.checkTime < flow.getStartTime()) {
                ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(flow.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = flow.getStatus();
            return this.isFlowSucceeded(status);
        }
        if (type.equals("JobFinish")) {
            String jobName = (String)this.slaOption.getInfo().get("JobName");
            ExecutableNode node = flow.getExecutableNode(jobName);
            if (node.getStartTime() < 0L) {
                return Boolean.FALSE;
            }
            if (this.checkTime < node.getStartTime()) {
                ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(node.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = node.getStatus();
            return this.isJobFinished(status);
        }
        if (type.equals("JobSucceed")) {
            String jobName = (String)this.slaOption.getInfo().get("JobName");
            ExecutableNode node = flow.getExecutableNode(jobName);
            if (node.getStartTime() < 0L) {
                return Boolean.FALSE;
            }
            if (this.checkTime < node.getStartTime()) {
                ReadablePeriod duration = Utils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(node.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = node.getStatus();
            return this.isJobSucceeded(status);
        }
        return Boolean.FALSE;
    }

    public Object eval() {
        ExecutableFlow flow;
        logger.info((Object)("Checking sla for execution " + this.execId));
        try {
            flow = executorManager.getExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Can't get executable flow.", (Throwable)e);
            e.printStackTrace();
            return Boolean.TRUE;
        }
        return this.isSlaMissed(flow);
    }

    public Object isSlaFailed() {
        ExecutableFlow flow;
        logger.info((Object)("Testing if sla failed for execution " + this.execId));
        try {
            flow = executorManager.getExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Can't get executable flow.", (Throwable)e);
            e.printStackTrace();
            return Boolean.TRUE;
        }
        return this.isSlaMissed(flow);
    }

    public Object isSlaPassed() {
        ExecutableFlow flow;
        logger.info((Object)("Testing if sla is good for execution " + this.execId));
        try {
            flow = executorManager.getExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Can't get executable flow.", (Throwable)e);
            e.printStackTrace();
            return Boolean.TRUE;
        }
        return this.isSlaGood(flow);
    }

    public Object getNum() {
        return null;
    }

    public void reset() {
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return "SlaChecker";
    }

    public ConditionChecker fromJson(Object obj) throws Exception {
        return SlaChecker.createFromJson((Object)obj);
    }

    public static SlaChecker createFromJson(Object obj) throws Exception {
        return SlaChecker.createFromJson((HashMap)((HashMap)obj));
    }

    public static SlaChecker createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals("SlaChecker")) {
            throw new Exception("Cannot create checker of SlaChecker from " + jsonObj.get("type"));
        }
        String id = (String)jsonObj.get("id");
        SlaOption slaOption = SlaOption.fromObject(jsonObj.get("slaOption"));
        int execId = Integer.valueOf((String)jsonObj.get("execId"));
        return new SlaChecker(id, slaOption, execId);
    }

    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("type", "SlaChecker");
        jsonObj.put("id", this.id);
        jsonObj.put("slaOption", this.slaOption.toObject());
        jsonObj.put("execId", String.valueOf(this.execId));
        return jsonObj;
    }

    public void stopChecker() {
    }

    public void setContext(Map<String, Object> context) {
    }

    public long getNextCheckTime() {
        return this.checkTime;
    }

    private boolean isFlowFinished(Status status) {
        if (status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED) || status.equals((Object)Status.SUCCEEDED)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isFlowSucceeded(Status status) {
        return status.equals((Object)Status.SUCCEEDED);
    }

    private boolean isJobFinished(Status status) {
        if (status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED) || status.equals((Object)Status.SUCCEEDED)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isJobSucceeded(Status status) {
        return status.equals((Object)Status.SUCCEEDED);
    }
}

