/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigGenericMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.pen.FakeRawKeyValueIterator;

public class PigMapReduce
extends PigGenericMapReduce {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduce
    extends PigGenericMapReduce.Reduce {
        @Override
        public Reducer.Context getIllustratorContext(org.apache.hadoop.mapred.jobcontrol.Job job, List<Pair<PigNullableWritable, Writable>> input, POPackage pkg) throws IOException, InterruptedException {
            return new IllustratorContext(job, input, pkg);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class IllustratorContext
        extends Reducer.Context {
            private PigNullableWritable currentKey;
            private PigNullableWritable nextKey;
            private NullableTuple nextValue;
            private List<NullableTuple> currentValues;
            private Iterator<Pair<PigNullableWritable, Writable>> it;
            private final ByteArrayOutputStream bos;
            private final DataOutputStream dos;
            private final RawComparator sortComparator;
            private final RawComparator groupingComparator;
            POPackage pack;

            public IllustratorContext(org.apache.hadoop.mapred.jobcontrol.Job job, List<Pair<PigNullableWritable, Writable>> input, POPackage pkg) throws IOException, InterruptedException {
                super((Reducer)Reduce.this, (Configuration)job.getJobConf(), new TaskAttemptID(), (RawKeyValueIterator)new FakeRawKeyValueIterator(input.iterator().hasNext()), null, null, null, null, null, null, PigNullableWritable.class, NullableTuple.class);
                this.currentKey = null;
                this.nextKey = null;
                this.nextValue = null;
                this.currentValues = null;
                this.pack = null;
                this.bos = new ByteArrayOutputStream();
                this.dos = new DataOutputStream(this.bos);
                Job nwJob = new Job((Configuration)job.getJobConf());
                this.sortComparator = nwJob.getSortComparator();
                this.groupingComparator = nwJob.getGroupingComparator();
                Collections.sort(input, new Comparator<Pair<PigNullableWritable, Writable>>(){

                    @Override
                    public int compare(Pair<PigNullableWritable, Writable> o1, Pair<PigNullableWritable, Writable> o2) {
                        try {
                            ((PigNullableWritable)o1.first).write(IllustratorContext.this.dos);
                            int l1 = IllustratorContext.this.bos.size();
                            ((PigNullableWritable)o2.first).write(IllustratorContext.this.dos);
                            int l2 = IllustratorContext.this.bos.size();
                            byte[] bytes = IllustratorContext.this.bos.toByteArray();
                            IllustratorContext.this.bos.reset();
                            return IllustratorContext.this.sortComparator.compare(bytes, 0, l1, bytes, l1, l2 - l1);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Serialization exception in sort:" + e.getMessage());
                        }
                    }
                });
                this.currentValues = new ArrayList<NullableTuple>();
                this.it = input.iterator();
                if (this.it.hasNext()) {
                    Pair<PigNullableWritable, Writable> entry = this.it.next();
                    this.nextKey = (PigNullableWritable)entry.first;
                    this.nextValue = (NullableTuple)entry.second;
                }
                this.pack = pkg;
            }

            public PigNullableWritable getCurrentKey() {
                return this.currentKey;
            }

            public boolean nextKey() {
                if (this.nextKey == null) {
                    return false;
                }
                this.currentKey = this.nextKey;
                this.currentValues.clear();
                this.currentValues.add(this.nextValue);
                this.nextKey = null;
                while (this.it.hasNext()) {
                    Pair<PigNullableWritable, Writable> entry = this.it.next();
                    if (this.groupingComparator.compare((Object)this.currentKey, entry.first) == 0) {
                        this.currentValues.add((NullableTuple)entry.second);
                        continue;
                    }
                    this.nextKey = (PigNullableWritable)entry.first;
                    this.nextValue = (NullableTuple)entry.second;
                    break;
                }
                return true;
            }

            public Iterable<NullableTuple> getValues() {
                return this.currentValues;
            }

            public void write(PigNullableWritable k, Writable t) {
            }

            public void progress() {
            }
        }
    }
}

