/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorageUtil {
    private static final String UTF8 = "UTF-8";

    public static byte parseFieldDel(String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Null delimiter");
        }
        if ((delimiter = StorageUtil.parseSingleQuotedString(delimiter)).length() > 1 && delimiter.charAt(0) != '\\') {
            throw new IllegalArgumentException("Delimeter must be a single character " + delimiter);
        }
        int fieldDel = 9;
        if (delimiter.length() == 1) {
            fieldDel = (byte)delimiter.charAt(0);
        } else if (delimiter.charAt(0) == '\\') {
            switch (delimiter.charAt(1)) {
                case 't': {
                    fieldDel = 9;
                    break;
                }
                case 'x': {
                    fieldDel = Integer.valueOf(delimiter.substring(2), 16).byteValue();
                    break;
                }
                case 'u': {
                    fieldDel = Integer.valueOf(delimiter.substring(2)).byteValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown delimiter " + delimiter);
                }
            }
        }
        return (byte)fieldDel;
    }

    public static void putField(OutputStream out, Object field) throws IOException {
        String tupleBeginDelim = "(";
        String tupleEndDelim = ")";
        String bagBeginDelim = "{";
        String bagEndDelim = "}";
        String mapBeginDelim = "[";
        String mapEndDelim = "]";
        String fieldDelim = ",";
        String mapKeyValueDelim = "#";
        switch (DataType.findType(field)) {
            case 1: {
                break;
            }
            case 5: {
                out.write(((Boolean)field).toString().getBytes());
                break;
            }
            case 10: {
                out.write(((Integer)field).toString().getBytes());
                break;
            }
            case 15: {
                out.write(((Long)field).toString().getBytes());
                break;
            }
            case 20: {
                out.write(((Float)field).toString().getBytes());
                break;
            }
            case 25: {
                out.write(((Double)field).toString().getBytes());
                break;
            }
            case 50: {
                byte[] b = ((DataByteArray)field).get();
                out.write(b, 0, b.length);
                break;
            }
            case 55: {
                out.write(((String)field).getBytes(UTF8));
                break;
            }
            case 100: {
                boolean mapHasNext = false;
                Map m = (Map)field;
                out.write(mapBeginDelim.getBytes(UTF8));
                for (Map.Entry e : m.entrySet()) {
                    if (mapHasNext) {
                        out.write(fieldDelim.getBytes(UTF8));
                    } else {
                        mapHasNext = true;
                    }
                    StorageUtil.putField(out, e.getKey());
                    out.write(mapKeyValueDelim.getBytes(UTF8));
                    StorageUtil.putField(out, e.getValue());
                }
                out.write(mapEndDelim.getBytes(UTF8));
                break;
            }
            case 110: {
                boolean tupleHasNext = false;
                Tuple t = (Tuple)field;
                out.write(tupleBeginDelim.getBytes(UTF8));
                for (int i = 0; i < t.size(); ++i) {
                    if (tupleHasNext) {
                        out.write(fieldDelim.getBytes(UTF8));
                    } else {
                        tupleHasNext = true;
                    }
                    StorageUtil.putField(out, t.get(i));
                    continue;
                }
                out.write(tupleEndDelim.getBytes(UTF8));
                break;
            }
            case 120: {
                boolean bagHasNext = false;
                out.write(bagBeginDelim.getBytes(UTF8));
                Iterator<Tuple> tupleIter = ((DataBag)field).iterator();
                while (tupleIter.hasNext()) {
                    if (bagHasNext) {
                        out.write(fieldDelim.getBytes(UTF8));
                    } else {
                        bagHasNext = true;
                    }
                    StorageUtil.putField(out, tupleIter.next());
                }
                out.write(bagEndDelim.getBytes(UTF8));
                break;
            }
            default: {
                int errCode = 2108;
                String msg = "Could not determine data type of field: " + field;
                throw new ExecException(msg, errCode, 4);
            }
        }
    }

    public static Tuple textToTuple(Text val, byte fieldDel) {
        byte[] buf = val.getBytes();
        int len = val.getLength();
        int start = 0;
        ArrayList<Object> protoTuple = new ArrayList<Object>();
        for (int i = 0; i < len; ++i) {
            if (buf[i] != fieldDel) continue;
            StorageUtil.readField(protoTuple, buf, start, i);
            start = i + 1;
        }
        if (start <= len) {
            StorageUtil.readField(protoTuple, buf, start, len);
        }
        return TupleFactory.getInstance().newTupleNoCopy(protoTuple);
    }

    private static void readField(ArrayList<Object> protoTuple, byte[] buf, int start, int end) {
        if (start == end) {
            protoTuple.add(null);
        } else {
            protoTuple.add(new DataByteArray(buf, start, end));
        }
    }

    private static String parseSingleQuotedString(String delimiter) {
        int endIndex;
        int startIndex = 0;
        while (startIndex < delimiter.length() && delimiter.charAt(startIndex++) != '\'') {
        }
        for (endIndex = startIndex; endIndex < delimiter.length() && delimiter.charAt(endIndex) != '\''; ++endIndex) {
            if (delimiter.charAt(endIndex) != '\\') continue;
            ++endIndex;
        }
        return endIndex < delimiter.length() ? delimiter.substring(startIndex, endIndex) : delimiter;
    }
}

