/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

class NoopStoreRemover
extends MROpPlanVisitor {
    private Log log = LogFactory.getLog(this.getClass());
    private Map<String, FileSpec> replacementMap = new HashMap<String, FileSpec>();
    private List<RemovableStore> removalQ;
    private List<POStore> storeQ;

    NoopStoreRemover(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DependencyOrderWalker<MapReduceOper, MROperPlan>(plan));
    }

    public void visitMROp(MapReduceOper mr) throws VisitorException {
        this.removalQ = new LinkedList<RemovableStore>();
        this.storeQ = new LinkedList<POStore>();
        new PhysicalRemover(mr.mapPlan).visit();
        new PhysicalRemover(mr.reducePlan).visit();
        for (RemovableStore removableStore : this.removalQ) {
            this.removeStore(removableStore);
        }
        for (POStore pOStore : this.storeQ) {
            pOStore.setInputSpec(null);
        }
    }

    private void removeStore(RemovableStore rem) {
        try {
            rem.split.removePlan(rem.storePlan);
            if (rem.split.getPlans().size() == 1) {
                PhysicalPlan plan = rem.split.getPlans().get(0);
                POStore store = (POStore)plan.getRoots().get(0);
                plan.remove(store);
                store.setInputs(rem.split.getInputs());
                rem.plan.replace(rem.split, store);
            }
        }
        catch (PlanException pe) {
            this.log.info((Object)("failed to remove unnecessary store from plan: " + pe.getMessage()));
        }
    }

    private class PhysicalRemover
    extends PhyPlanVisitor {
        PhysicalRemover(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        public void visit() throws VisitorException {
            super.visit();
        }

        public void visitLoad(POLoad load) {
            FileSpec spec = (FileSpec)NoopStoreRemover.this.replacementMap.get(load.getLFile().getFileName());
            if (spec != null) {
                load.setLFile(spec);
            }
        }

        public void visitStore(POStore store) {
            NoopStoreRemover.this.storeQ.add(store);
        }

        public void visitSplit(POSplit split) throws VisitorException {
            super.visitSplit(split);
            FileSpec lFile = null;
            FileSpec sFile = null;
            PhysicalPlan tmpStore = null;
            for (PhysicalPlan plan : split.getPlans()) {
                PhysicalOperator op;
                if (plan.size() != 1 || !((op = (PhysicalOperator)plan.getRoots().get(0)) instanceof POStore)) continue;
                POStore store = (POStore)op;
                if (store.isTmpStore()) {
                    tmpStore = plan;
                    sFile = store.getSFile();
                    continue;
                }
                if (store.getInputSpec() == null) continue;
                lFile = store.getInputSpec();
            }
            if (tmpStore != null && lFile != null) {
                RemovableStore rem = new RemovableStore();
                rem.storePlan = tmpStore;
                rem.plan = (PhysicalPlan)this.mCurrentWalker.getPlan();
                rem.split = split;
                NoopStoreRemover.this.removalQ.add(rem);
                NoopStoreRemover.this.replacementMap.put(sFile.getFileName(), lFile);
            }
        }
    }

    private static class RemovableStore {
        public PhysicalPlan storePlan;
        public PhysicalPlan plan;
        public POSplit split;

        private RemovableStore() {
        }
    }
}

