/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.UnaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class PONegative
extends UnaryExpressionOperator {
    private static final long serialVersionUID = 1L;

    public PONegative(OperatorKey k, int rp) {
        super(k, rp);
    }

    public PONegative(OperatorKey k) {
        super(k);
    }

    public PONegative(OperatorKey k, int rp, ExpressionOperator input) {
        super(k, rp);
        this.expr = input;
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitNegative(this);
    }

    public String name() {
        return "PONegative[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    public Result getNext(Double d) throws ExecException {
        Result res = this.expr.getNext(d);
        if (res.returnStatus == 0 && res.result != null) {
            res.result = -1.0 * (Double)res.result;
        }
        return res;
    }

    public Result getNext(Float f) throws ExecException {
        Result res = this.expr.getNext(f);
        if (res.returnStatus == 0 && res.result != null) {
            res.result = Float.valueOf(-1.0f * ((Float)res.result).floatValue());
        }
        return res;
    }

    public Result getNext(Integer i) throws ExecException {
        Result res = this.expr.getNext(i);
        if (res.returnStatus == 0 && res.result != null) {
            res.result = -1 * (Integer)res.result;
        }
        return res;
    }

    public Result getNext(Long l) throws ExecException {
        Result res = this.expr.getNext(l);
        if (res.returnStatus == 0 && res.result != null) {
            res.result = -1L * (Long)res.result;
        }
        return res;
    }

    public PONegative clone() throws CloneNotSupportedException {
        PONegative clone = new PONegative(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }

    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return (Tuple)out;
    }
}

