/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.regex;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORegexp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.regex.CompiledAutomaton;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.regex.CompiledRegex;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.regex.NonConstantRegex;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.regex.RegexImpl;

public class RegexInit
implements RegexImpl,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] javaRegexOnly = new String[]{"&&", "??", "*?", "+?", "}?", "?+", "*+", "++", "}+", "^", "$", "(?"};
    PORegexp regexop = null;
    int side = -1;
    boolean rhsConstant = false;

    public RegexInit(PORegexp regexoperator) {
        this.regexop = regexoperator;
    }

    public void setConstExpr(boolean rhsConstant) {
        this.rhsConstant = rhsConstant;
    }

    private int determineBestRegexMethod(String pattern) {
        int precedingEsc;
        for (int i = 0; i < javaRegexOnly.length; ++i) {
            int j = pattern.length();
            while (j > 0) {
                if ((j = pattern.lastIndexOf(javaRegexOnly[i], j)) > 0) {
                    int precedingEsc2 = this.precedingEscapes(pattern, j);
                    if (precedingEsc2 % 2 == 0) {
                        return 0;
                    }
                    j -= precedingEsc2;
                    continue;
                }
                if (j != 0) continue;
                return 0;
            }
        }
        int index = pattern.indexOf(91);
        if (index >= 0) {
            precedingEsc = this.precedingEscapes(pattern, index);
            if (index != 0) {
                while (precedingEsc % 2 == 1) {
                    index = pattern.indexOf(91, index + 1);
                    precedingEsc = this.precedingEscapes(pattern, index);
                }
            }
            int index2 = 0;
            int index3 = 0;
            while (index != -1 && index < pattern.length() && (index2 = pattern.indexOf(93, index)) != -1) {
                precedingEsc = this.precedingEscapes(pattern, index2);
                while (precedingEsc % 2 == 1) {
                    index2 = pattern.indexOf(93, index2 + 1);
                    precedingEsc = this.precedingEscapes(pattern, index2);
                }
                if (index2 == -1) break;
                index3 = pattern.indexOf(91, index + 1);
                precedingEsc = this.precedingEscapes(pattern, index3);
                if (index3 == -1) break;
                while (precedingEsc % 2 == 1) {
                    index3 = pattern.indexOf(91, index3 + 1);
                    precedingEsc = this.precedingEscapes(pattern, index3);
                }
                if (index3 == -1) break;
                if (index3 < index2) {
                    return 0;
                }
                index = index3;
            }
        }
        if ((index = pattern.lastIndexOf(92)) > -1) {
            precedingEsc = this.precedingEscapes(pattern, index);
            while (index != -1) {
                char index_1;
                if (precedingEsc % 2 == 0 && index + 1 < pattern.length() && ((index_1 = pattern.charAt(index + 1)) == '1' || index_1 == '2' || index_1 == '3' || index_1 == '4' || index_1 == '5' || index_1 == '6' || index_1 == '7' || index_1 == '8' || index_1 == '9' || index_1 == 'a' || index_1 == 'e' || index_1 == '0' || index_1 == 'x' || index_1 == 'u' || index_1 == 'c' || index_1 == 'Q' || index_1 == 'w' || index_1 == 'W' || index_1 == 'd' || index_1 == 'D' || index_1 == 's' || index_1 == 'S' || index_1 == 'p' || index_1 == 'P' || index_1 == 'b' || index_1 == 'B' || index_1 == 'A' || index_1 == 'G' || index_1 == 'z' || index_1 == 'Z')) {
                    return 0;
                }
                precedingEsc = -1;
                if ((index -= precedingEsc + 1) < 0) continue;
                index = pattern.lastIndexOf(92, index);
                precedingEsc = this.precedingEscapes(pattern, index);
            }
        }
        return 1;
    }

    private int precedingEscapes(String pattern, int startIndex) {
        if (startIndex > 0) {
            int precedingEscapes = 0;
            for (int j = startIndex - 1; j >= 0 && pattern.charAt(j) == '\\'; --j) {
                ++precedingEscapes;
            }
            return precedingEscapes;
        }
        if (startIndex == 0) {
            return 0;
        }
        return -1;
    }

    private RegexImpl compile(String pattern) {
        RegexImpl impl = null;
        int regexMethod = this.determineBestRegexMethod(pattern);
        switch (regexMethod) {
            case 0: {
                impl = new CompiledRegex(Pattern.compile(pattern));
                break;
            }
            case 1: {
                try {
                    impl = new CompiledAutomaton(pattern);
                }
                catch (IllegalArgumentException e) {
                    Log log = LogFactory.getLog(this.getClass());
                    log.debug((Object)("Got an IllegalArgumentException for Pattern: " + pattern));
                    log.debug((Object)e.getMessage());
                    log.debug((Object)"Switching to java.util.regex");
                    impl = new CompiledRegex(Pattern.compile(pattern));
                }
                break;
            }
        }
        return impl;
    }

    public boolean match(String lhs, String rhs) {
        RegexImpl impl = null;
        impl = this.rhsConstant ? this.compile(rhs) : new NonConstantRegex();
        this.regexop.setImplementation(impl);
        return impl.match(lhs, rhs);
    }
}

