/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalSortedBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSort
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(POSort.class);
    private static final long serialVersionUID = 1L;
    private List<PhysicalPlan> sortPlans;
    private List<Byte> ExprOutputTypes;
    private List<Boolean> mAscCols;
    private POUserComparisonFunc mSortFunc;
    private Comparator<Tuple> mComparator;
    private boolean inputsAccumulated = false;
    private long limit;
    public boolean isUDFComparatorUsed = false;
    private DataBag sortedBag;
    transient Iterator<Tuple> it;

    public POSort(OperatorKey k, int rp, List inp, List<PhysicalPlan> sortPlans, List<Boolean> mAscCols, POUserComparisonFunc mSortFunc) {
        super(k, rp, inp);
        this.sortPlans = sortPlans;
        this.mAscCols = mAscCols;
        this.limit = -1L;
        this.mSortFunc = mSortFunc;
        if (mSortFunc == null) {
            this.mComparator = new SortComparator();
            this.ExprOutputTypes = new ArrayList<Byte>(sortPlans.size());
            for (PhysicalPlan plan : sortPlans) {
                this.ExprOutputTypes.add(((PhysicalOperator)plan.getLeaves().get(0)).getResultType());
            }
        } else {
            this.mComparator = new UDFSortComparator();
            this.isUDFComparatorUsed = true;
        }
    }

    public POSort(OperatorKey k, int rp, List inp) {
        super(k, rp, inp);
    }

    public POSort(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POSort(OperatorKey k, List inp) {
        super(k, inp);
    }

    public POSort(OperatorKey k) {
        super(k);
    }

    @Override
    public String name() {
        return this.getAliasString() + "POSort" + "[" + DataType.findTypeName(this.resultType) + "]" + "(" + (this.mSortFunc != null ? this.mSortFunc.getFuncSpec() : "") + ")" + " - " + this.mKey.toString();
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result res = new Result();
        if (!this.inputsAccumulated) {
            res = this.processInput();
            String bagType = null;
            if (PigMapReduce.sJobConfInternal.get() != null) {
                bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.sort.type");
            }
            this.sortedBag = bagType != null && bagType.equalsIgnoreCase("default") ? BagFactory.getInstance().newSortedBag(this.mComparator) : new InternalSortedBag(3, this.mComparator);
            while (res.returnStatus != 3) {
                if (res.returnStatus == 2) {
                    log.error((Object)"Error in reading from the inputs");
                    return res;
                }
                if (res.returnStatus == 1) {
                    res = this.processInput();
                    continue;
                }
                this.sortedBag.add((Tuple)res.result);
                res = this.processInput();
            }
            this.inputsAccumulated = true;
        }
        if (this.it == null) {
            this.it = this.sortedBag.iterator();
        }
        if (this.it.hasNext()) {
            res.result = this.it.next();
            this.illustratorMarkup(res.result, res.result, 0);
            res.returnStatus = 0;
        } else {
            res.returnStatus = (byte)3;
            this.reset();
        }
        return res;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitSort(this);
    }

    @Override
    public void reset() {
        this.inputsAccumulated = false;
        this.sortedBag = null;
        this.it = null;
    }

    public List<PhysicalPlan> getSortPlans() {
        return this.sortPlans;
    }

    public void setSortPlans(List<PhysicalPlan> sortPlans) {
        this.sortPlans = sortPlans;
    }

    public POUserComparisonFunc getMSortFunc() {
        return this.mSortFunc;
    }

    public void setMSortFunc(POUserComparisonFunc sortFunc) {
        this.mSortFunc = sortFunc;
    }

    public List<Boolean> getMAscCols() {
        return this.mAscCols;
    }

    public void setLimit(long l) {
        this.limit = l;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isLimited() {
        return this.limit != -1L;
    }

    @Override
    public POSort clone() throws CloneNotSupportedException {
        ArrayList<PhysicalPlan> clonePlans = new ArrayList<PhysicalPlan>(this.sortPlans.size());
        for (PhysicalPlan plan : this.sortPlans) {
            clonePlans.add(plan.clone());
        }
        ArrayList<Boolean> cloneAsc = new ArrayList<Boolean>(this.mAscCols.size());
        for (Boolean b : this.mAscCols) {
            cloneAsc.add(b);
        }
        POUserComparisonFunc cloneFunc = null;
        if (this.mSortFunc != null) {
            cloneFunc = this.mSortFunc.clone();
        }
        return new POSort(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, null, clonePlans, cloneAsc, cloneFunc);
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add((Tuple)in);
            this.illustrator.addData((Tuple)out);
        }
        return (Tuple)out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UDFSortComparator
    implements Comparator<Tuple>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Tuple t1, Tuple t2) {
            POSort.this.mSortFunc.attachInput(t1, t2);
            Integer i = null;
            Result res = null;
            try {
                res = POSort.this.mSortFunc.getNext(i);
            }
            catch (ExecException e) {
                log.error((Object)("Input not ready. Error on reading from input. " + e.getMessage()));
            }
            if (res != null) {
                return (Integer)res.result;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SortComparator
    implements Comparator<Tuple>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Tuple o1, Tuple o2) {
            int count = 0;
            int ret = 0;
            if (POSort.this.sortPlans == null || POSort.this.sortPlans.size() == 0) {
                return 0;
            }
            for (PhysicalPlan plan : POSort.this.sortPlans) {
                try {
                    plan.attachInput(o1);
                    Result res1 = this.getResult(plan, (Byte)POSort.this.ExprOutputTypes.get(count));
                    plan.attachInput(o2);
                    Result res2 = this.getResult(plan, (Byte)POSort.this.ExprOutputTypes.get(count));
                    if (res1.returnStatus != 0 || res2.returnStatus != 0) {
                        log.error((Object)("Error processing the input in the expression plan : " + plan.toString()));
                        continue;
                    }
                    if (!((Boolean)POSort.this.mAscCols.get(count++) != false ? (ret = DataType.compare(res1.result, res2.result)) != 0 : (ret = DataType.compare(res2.result, res1.result)) != 0)) continue;
                    return ret;
                }
                catch (ExecException e) {
                    log.error((Object)("Invalid result while executing the expression plan : " + plan.toString() + "\n" + e.getMessage()));
                }
            }
            return ret;
        }

        private Result getResult(PhysicalPlan plan, byte resultType) throws ExecException {
            ExpressionOperator Op = (ExpressionOperator)plan.getLeaves().get(0);
            Result res = null;
            switch (resultType) {
                case 10: 
                case 15: 
                case 20: 
                case 25: 
                case 50: 
                case 55: 
                case 110: {
                    res = Op.getNext(PhysicalOperator.getDummy(resultType), resultType);
                    break;
                }
                default: {
                    int errCode = 2082;
                    String msg = "Did not expect result of type: " + DataType.findTypeName(resultType);
                    throw new ExecException(msg, errCode, 4);
                }
            }
            return res;
        }
    }
}

