/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.impl.util.ObjectSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDFContext {
    private Configuration jconf = null;
    private HashMap<UDFContextKey, Properties> udfConfs = new HashMap();
    private Properties clientSysProps;
    private static final String CLIENT_SYS_PROPS = "pig.client.sys.props";
    private static final String UDF_CONTEXT = "pig.udf.context";
    private static ThreadLocal<UDFContext> tss = new ThreadLocal();

    private UDFContext() {
    }

    public static UDFContext getUDFContext() {
        if (tss.get() == null) {
            UDFContext ctx = new UDFContext();
            tss.set(ctx);
        }
        return tss.get();
    }

    public void setClientSystemProps() {
        this.clientSysProps = System.getProperties();
    }

    public Properties getClientSystemProps() {
        return this.clientSysProps;
    }

    public void addJobConf(Configuration conf) {
        this.jconf = conf;
    }

    public Configuration getJobConf() {
        if (this.jconf != null) {
            return new Configuration(this.jconf);
        }
        return null;
    }

    public Properties getUDFProperties(Class c, String[] args) {
        UDFContextKey k = this.generateKey(c, args);
        Properties p = this.udfConfs.get(k);
        if (p == null) {
            p = new Properties();
            this.udfConfs.put(k, p);
        }
        return p;
    }

    public Properties getUDFProperties(Class c) {
        UDFContextKey k = this.generateKey(c, null);
        Properties p = this.udfConfs.get(k);
        if (p == null) {
            p = new Properties();
            this.udfConfs.put(k, p);
        }
        return p;
    }

    public void serialize(Configuration conf) throws IOException {
        conf.set(UDF_CONTEXT, ObjectSerializer.serialize(this.udfConfs));
        conf.set(CLIENT_SYS_PROPS, ObjectSerializer.serialize(this.clientSysProps));
    }

    public void deserialize() throws IOException {
        this.udfConfs = (HashMap)ObjectSerializer.deserialize(this.jconf.get(UDF_CONTEXT));
        this.clientSysProps = (Properties)ObjectSerializer.deserialize(this.jconf.get(CLIENT_SYS_PROPS));
    }

    private UDFContextKey generateKey(Class<?> c, String[] args) {
        return new UDFContextKey(c.getName(), args);
    }

    public void reset() {
        this.udfConfs.clear();
    }

    public boolean isUDFConfEmpty() {
        return this.udfConfs.isEmpty();
    }

    private static class UDFContextKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String className;
        private String[] args;

        UDFContextKey() {
        }

        UDFContextKey(String className, String[] args) {
            this.className = className;
            this.args = args;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.args);
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UDFContextKey other = (UDFContextKey)obj;
            if (!Arrays.equals(this.args, other.args)) {
                return false;
            }
            return !(this.className == null ? other.className != null : !this.className.equals(other.className));
        }
    }
}

