/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp;

import azkaban.user.UserManager;
import azkaban.utils.Props;
import azkaban.webapp.session.SessionCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AzkabanServer {
    private static final Logger logger = Logger.getLogger(AzkabanServer.class);
    public static final String AZKABAN_PROPERTIES_FILE = "azkaban.properties";
    public static final String AZKABAN_PRIVATE_PROPERTIES_FILE = "azkaban.private.properties";
    public static final String DEFAULT_CONF_PATH = "conf";

    public static Props loadProps(String[] args) {
        return AzkabanServer.loadProps((String[])args, (OptionParser)new OptionParser());
    }

    public static Props loadProps(String[] args, OptionParser parser) {
        ArgumentAcceptingOptionSpec configDirectory = parser.acceptsAll(Arrays.asList("c", "conf"), "The conf directory for Azkaban.").withRequiredArg().describedAs("conf").ofType(String.class);
        Props azkabanSettings = null;
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)configDirectory)) {
            String path = (String)options.valueOf((OptionSpec)configDirectory);
            logger.info((Object)("Loading azkaban settings file from " + path));
            File dir = new File(path);
            if (!dir.exists()) {
                logger.error((Object)("Conf directory " + path + " doesn't exist."));
            } else if (!dir.isDirectory()) {
                logger.error((Object)("Conf directory " + path + " isn't a directory."));
            } else {
                azkabanSettings = AzkabanServer.loadAzkabanConfigurationFromDirectory((File)dir);
            }
        } else {
            logger.info((Object)"Conf parameter not set, attempting to get value from AZKABAN_HOME env.");
            azkabanSettings = AzkabanServer.loadConfigurationFromAzkabanHome();
        }
        return azkabanSettings;
    }

    private static Props loadAzkabanConfigurationFromDirectory(File dir) {
        File azkabanPrivatePropsFile = new File(dir, "azkaban.private.properties");
        File azkabanPropsFile = new File(dir, "azkaban.properties");
        Props props = null;
        try {
            if (azkabanPrivatePropsFile.exists() && azkabanPrivatePropsFile.isFile()) {
                logger.info((Object)"Loading azkaban private properties file");
                props = new Props(null, azkabanPrivatePropsFile);
            }
            if (azkabanPropsFile.exists() && azkabanPropsFile.isFile()) {
                logger.info((Object)"Loading azkaban properties file");
                props = new Props(props, azkabanPropsFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"File not found. Could not load azkaban config file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"File found, but error reading. Could not load azkaban config file", (Throwable)e);
        }
        return props;
    }

    private static Props loadConfigurationFromAzkabanHome() {
        String azkabanHome = System.getenv("AZKABAN_HOME");
        if (azkabanHome == null) {
            logger.error((Object)"AZKABAN_HOME not set. Will try default.");
            return null;
        }
        if (!new File(azkabanHome).isDirectory() || !new File(azkabanHome).canRead()) {
            logger.error((Object)(String.valueOf(azkabanHome) + " is not a readable directory."));
            return null;
        }
        File confPath = new File(azkabanHome, "conf");
        if (!(confPath.exists() && confPath.isDirectory() && confPath.canRead())) {
            logger.error((Object)(String.valueOf(azkabanHome) + " does not contain a readable conf directory."));
            return null;
        }
        return AzkabanServer.loadAzkabanConfigurationFromDirectory((File)confPath);
    }

    public abstract Props getServerProps();

    public abstract SessionCache getSessionCache();

    public abstract VelocityEngine getVelocityEngine();

    public abstract UserManager getUserManager();
}

