/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableNode;
import azkaban.executor.Status;
import azkaban.utils.TypedMapWrapper;
import java.util.HashMap;
import java.util.Map;

public class ExecutionAttempt {
    public static final String ATTEMPT_PARAM = "attempt";
    public static final String STATUS_PARAM = "status";
    public static final String STARTTIME_PARAM = "startTime";
    public static final String ENDTIME_PARAM = "endTime";
    private int attempt = 0;
    private long startTime = -1L;
    private long endTime = -1L;
    private Status status;

    public ExecutionAttempt(int attempt, ExecutableNode executable) {
        this.attempt = attempt;
        this.startTime = executable.getStartTime();
        this.endTime = executable.getEndTime();
        this.status = executable.getStatus();
    }

    public ExecutionAttempt(int attempt, long startTime, long endTime, Status status) {
        this.attempt = attempt;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public static ExecutionAttempt fromObject(Object obj) {
        Map map = (Map)obj;
        TypedMapWrapper wrapper = new TypedMapWrapper(map);
        int attempt = wrapper.getInt((Object)ATTEMPT_PARAM);
        long startTime = wrapper.getLong((Object)STARTTIME_PARAM);
        long endTime = wrapper.getLong((Object)ENDTIME_PARAM);
        Status status = Status.valueOf((String)wrapper.getString((Object)STATUS_PARAM));
        return new ExecutionAttempt(attempt, startTime, endTime, status);
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> attempts = new HashMap<String, Object>();
        attempts.put(ATTEMPT_PARAM, this.attempt);
        attempts.put(STARTTIME_PARAM, this.startTime);
        attempts.put(ENDTIME_PARAM, this.endTime);
        attempts.put(STATUS_PARAM, this.status.toString());
        return attempts;
    }
}

