/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.jobExecutor;

import azkaban.jobExecutor.JavaProcessJob;
import azkaban.test.jobExecutor.Utils;
import azkaban.utils.Props;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JavaProcessJobTest {
    private JavaProcessJob job = null;
    private Props props = null;
    private Logger log = Logger.getLogger(JavaProcessJob.class);
    private static String classPaths;
    private static final String inputContent = "Quick Change in Strategy for a Bookseller \n By JULIE BOSMAN \nPublished: August 11, 2010 \n \nTwelve years later, it may be Joe Fox\ufffds turn to worry. Readers have gone from skipping small \nbookstores to wondering if they need bookstores at all. More people are ordering books online  \nor plucking them from the best-seller bin at Wal-Mart";
    private static final String errorInputContent = "Quick Change in Strategy for a Bookseller \n By JULIE BOSMAN \nPublished: August 11, 2010 \n \nTwelve years later, it may be Joe Fox\ufffds turn to worry. Readers have gone from skipping small \nbookstores to wondering if they need bookstores at all. More people are ordering books online  \nor plucking them from the best-seller bin at Wal-Mart\n stop_here But the threat that has the industry and some readers the most rattled is the growth of e-books. \n In the first five months of 2009, e-books made up 2.9 percent of trade book sales. In the same period \nin 2010, sales of e-books, which generally cost less than hardcover books, grew to 8.5 percent, according \nto the Association of American Publishers, spurred by sales of the Amazon Kindle and the new Apple iPad. \nFor Barnes & Noble, long the largest and most powerful bookstore chain in the country, the new competition \nhas led to declining profits and store traffic.";
    private static String inputFile;
    private static String errorInputFile;
    private static String outputFile;

    @BeforeClass
    public static void init() {
        Properties prop = System.getProperties();
        classPaths = String.format("'%s'", prop.getProperty("java.class.path", null));
        long time = new Date().getTime();
        inputFile = "/tmp/azkaban_input_" + time;
        errorInputFile = "/tmp/azkaban_input_error_" + time;
        outputFile = "/tmp/azkaban_output_" + time;
        try {
            Utils.dumpFile((String)inputFile, (String)inputContent);
            Utils.dumpFile((String)errorInputFile, (String)errorInputContent);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Assert.fail((String)("error in creating input file:" + e.getLocalizedMessage()));
        }
    }

    @AfterClass
    public static void cleanup() {
        Utils.removeFile((String)inputFile);
        Utils.removeFile((String)errorInputFile);
    }

    @Before
    public void setUp() {
        this.props = new Props();
        this.props.put("working.dir", ".");
        this.props.put("type", "java");
        this.props.put("fullPath", ".");
        this.job = new JavaProcessJob("testJavaProcess", this.props, this.props, this.log);
    }

    @Test
    public void testJavaJob() throws Exception {
        this.props.put("job.class", "azkaban.test.jobExecutor.WordCountLocal");
        this.props.put("working.dir", ".");
        this.props.put("input", inputFile);
        this.props.put("output", outputFile);
        this.props.put("classpath", classPaths);
        this.job.run();
    }

    @Test
    public void testJavaJobHashmap() throws Exception {
        this.props.put("job.class", "azkaban.test.executor.SleepJavaJob");
        this.props.put("seconds", Integer.valueOf(1));
        this.props.put("working.dir", ".");
        this.props.put("input", inputFile);
        this.props.put("output", outputFile);
        this.props.put("classpath", classPaths);
        this.job.run();
    }

    @Test
    public void testFailedJavaJob() throws Exception {
        this.props.put("job.class", "azkaban.test.jobExecutor.WordCountLocal");
        this.props.put("working.dir", ".");
        this.props.put("input", errorInputFile);
        this.props.put("output", outputFile);
        this.props.put("classpath", classPaths);
        try {
            this.job.run();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

