/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.executor;

import java.util.Map;

public class SleepJavaJob {
    private boolean fail;
    private String seconds;
    private int attempts;
    private int currentAttempt;
    private String id;

    public SleepJavaJob(String id, Map<String, String> parameters) {
        this.id = id;
        String failStr = parameters.get("fail");
        this.fail = failStr != null && !failStr.equals("false");
        this.currentAttempt = parameters.containsKey("azkaban.job.attempt") ? Integer.parseInt(parameters.get("azkaban.job.attempt")) : 0;
        String attemptString = parameters.get("passRetry");
        this.attempts = attemptString == null ? -1 : Integer.valueOf(attemptString);
        this.seconds = parameters.get("seconds");
        if (this.fail) {
            System.out.println("Planning to fail after " + this.seconds + " seconds. Attempts left " + this.currentAttempt + " of " + this.attempts);
        } else {
            System.out.println("Planning to succeed after " + this.seconds + " seconds.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this.seconds == null) {
            throw new RuntimeException("Seconds not set");
        }
        int sec = Integer.parseInt(this.seconds);
        System.out.println("Sec " + sec);
        SleepJavaJob sleepJavaJob = this;
        synchronized (sleepJavaJob) {
            try {
                this.wait(sec * 1000);
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted " + this.fail);
            }
        }
        if (this.fail && (this.attempts <= 0 || this.currentAttempt <= this.attempts)) {
            throw new Exception("I failed because I had to.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws Exception {
        System.out.println("Cancelled called on Sleep job");
        this.fail = true;
        SleepJavaJob sleepJavaJob = this;
        synchronized (sleepJavaJob) {
            this.notifyAll();
        }
    }
}

