/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerException;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActionTypeLoader {
    private static Logger logger = Logger.getLogger(ActionTypeLoader.class);
    public static final String DEFAULT_TRIGGER_ACTION_PLUGIN_DIR = "plugins/triggeractions";
    protected static Map<String, Class<? extends TriggerAction>> actionToClass = new HashMap();

    public void init(Props props) throws TriggerException {
    }

    public synchronized void registerActionType(String type, Class<? extends TriggerAction> actionClass) {
        logger.info((Object)("Registering action " + type));
        if (!actionToClass.containsKey(type)) {
            actionToClass.put(type, actionClass);
        }
    }

    public static void registerBuiltinActions(Map<String, Class<? extends TriggerAction>> builtinActions) {
        actionToClass.putAll(builtinActions);
        for (String type : builtinActions.keySet()) {
            logger.info((Object)("Loaded " + type + " action."));
        }
    }

    public TriggerAction createActionFromJson(String type, Object obj) throws Exception {
        TriggerAction action = null;
        Class actionClass = (Class)actionToClass.get(type);
        if (actionClass == null) {
            throw new Exception("Action Type " + type + " not supported!");
        }
        action = (TriggerAction)Utils.invokeStaticMethod((ClassLoader)actionClass.getClassLoader(), (String)actionClass.getName(), (String)"createFromJson", (Object[])new Object[]{obj});
        return action;
    }

    public TriggerAction createAction(String type, Object ... args) {
        TriggerAction action = null;
        Class actionClass = (Class)actionToClass.get(type);
        action = (TriggerAction)Utils.callConstructor((Class)actionClass, (Object[])args);
        return action;
    }

    public Set<String> getSupportedActions() {
        return actionToClass.keySet();
    }
}

