/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.utils;

import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileIOUtilsTest {
    File sourceDir = new File("unit/project/testjob");
    File destDir = new File("unit/executions/unixsymlink");

    @Before
    public void setUp() throws Exception {
        if (this.destDir.exists()) {
            FileUtils.deleteDirectory((File)this.destDir);
        }
        this.destDir.mkdirs();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSymlinkCopy() throws IOException {
        FileIOUtils.createDeepSymlink((File)this.sourceDir, (File)this.destDir);
    }

    @Test
    public void testSymlinkCopyNonSource() {
        boolean exception = false;
        try {
            FileIOUtils.createDeepSymlink((File)new File(this.sourceDir, "idonotexist"), (File)this.destDir);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.out.println("Handled this case nicely.");
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testAsciiUTF() throws IOException {
        String foreignText = "abcdefghijklmnopqrstuvwxyz";
        byte[] utf8ByteArray = this.createUTF8ByteArray(foreignText);
        int length = utf8ByteArray.length;
        System.out.println("char length:" + foreignText.length() + " utf8BytesLength:" + utf8ByteArray.length + " for:" + foreignText);
        Pair pair = FileIOUtils.getUtf8Range((byte[])utf8ByteArray, (int)1, (int)(length - 6));
        System.out.println("Pair :" + pair.toString());
        String recreatedString = new String(utf8ByteArray, 1, length - 6, "UTF-8");
        System.out.println("recreatedString:" + recreatedString);
        String correctString = new String(utf8ByteArray, (int)((Integer)pair.getFirst()), (int)((Integer)pair.getSecond()), "UTF-8");
        System.out.println("correctString:" + correctString);
        Assert.assertEquals((Object)pair, (Object)new Pair((Object)1, (Object)20));
        Assert.assertEquals((long)correctString.length(), (long)(foreignText.length() - 6));
    }

    @Test
    public void testForeignUTF() throws IOException {
        String foreignText = "\uc548\ub155\ud558\uc138\uc694, \uc81c \uc774\ub984\uc740 \ubc15\ubcd1\ud638\uc785\ub2c8\ub2e4";
        byte[] utf8ByteArray = this.createUTF8ByteArray(foreignText);
        int length = utf8ByteArray.length;
        System.out.println("char length:" + foreignText.length() + " utf8BytesLength:" + utf8ByteArray.length + " for:" + foreignText);
        Pair pair = FileIOUtils.getUtf8Range((byte[])utf8ByteArray, (int)1, (int)(length - 6));
        System.out.println("Pair :" + pair.toString());
        String recreatedString = new String(utf8ByteArray, 1, length - 6, "UTF-8");
        System.out.println("recreatedString:" + recreatedString);
        String correctString = new String(utf8ByteArray, (int)((Integer)pair.getFirst()), (int)((Integer)pair.getSecond()), "UTF-8");
        System.out.println("correctString:" + correctString);
        Assert.assertEquals((Object)pair, (Object)new Pair((Object)3, (Object)40));
        Assert.assertEquals((long)correctString.length(), (long)(foreignText.length() - 3));
        String mixedText = "abc\uc548\ub155\ud558\uc138\uc694, \uc81c \uc774\ub984\uc740 \ubc15\ubcd1\ud638\uc785\ub2c8\ub2e4";
        byte[] mixedBytes = this.createUTF8ByteArray(mixedText);
        Pair pair2 = FileIOUtils.getUtf8Range((byte[])mixedBytes, (int)1, (int)(length - 4));
        correctString = new String(mixedBytes, (int)((Integer)pair2.getFirst()), (int)((Integer)pair2.getSecond()), "UTF-8");
        System.out.println("correctString:" + correctString);
        Assert.assertEquals((Object)pair2, (Object)new Pair((Object)1, (Object)45));
        Assert.assertEquals((long)correctString.length(), (long)(mixedText.length() - 3));
    }

    private byte[] createUTF8ByteArray(String text) {
        byte[] textBytes = null;
        try {
            textBytes = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return textBytes;
    }
}

