/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp.event;

import azkaban.execapp.event.FlowWatcher;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;

public class RemoteFlowWatcher
extends FlowWatcher {
    private static final long CHECK_INTERVAL_MS = 60000L;
    private int execId;
    private ExecutorLoader loader;
    private ExecutableFlow flow;
    private RemoteUpdaterThread thread;
    private boolean isShutdown = false;
    private long checkIntervalMs = 60000L;

    public RemoteFlowWatcher(int execId, ExecutorLoader loader) {
        this(execId, loader, 60000L);
    }

    public RemoteFlowWatcher(int execId, ExecutorLoader loader, long interval) {
        super(execId);
        this.checkIntervalMs = interval;
        try {
            this.flow = loader.fetchExecutableFlow(execId);
        }
        catch (ExecutorManagerException e) {
            return;
        }
        super.setFlow(this.flow);
        this.loader = loader;
        this.execId = execId;
        if (this.flow != null) {
            this.thread = new RemoteUpdaterThread();
            this.thread.setName("Remote-watcher-flow-" + execId);
            this.thread.start();
        }
    }

    @Override
    public synchronized void stopWatcher() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        super.failAllWatches();
        this.loader = null;
        this.flow = null;
    }

    private class RemoteUpdaterThread
    extends Thread {
        private RemoteUpdaterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                ExecutableFlow updateFlow = null;
                try {
                    updateFlow = RemoteFlowWatcher.this.loader.fetchExecutableFlow(RemoteFlowWatcher.this.execId);
                }
                catch (ExecutorManagerException e) {
                    e.printStackTrace();
                    RemoteFlowWatcher.this.isShutdown = true;
                }
                if (RemoteFlowWatcher.this.flow == null) {
                    RemoteFlowWatcher.this.flow = updateFlow;
                } else {
                    RemoteFlowWatcher.this.flow.setStatus(updateFlow.getStatus());
                    RemoteFlowWatcher.this.flow.setEndTime(updateFlow.getEndTime());
                    RemoteFlowWatcher.this.flow.setUpdateTime(updateFlow.getUpdateTime());
                    for (ExecutableNode node : RemoteFlowWatcher.this.flow.getExecutableNodes()) {
                        String jobId = node.getJobId();
                        ExecutableNode newNode = updateFlow.getExecutableNode(jobId);
                        long updateTime = node.getUpdateTime();
                        node.setUpdateTime(newNode.getUpdateTime());
                        node.setStatus(newNode.getStatus());
                        node.setStartTime(newNode.getStartTime());
                        node.setEndTime(newNode.getEndTime());
                        if (updateTime >= newNode.getUpdateTime()) continue;
                        RemoteFlowWatcher.this.handleJobFinished(jobId, newNode.getStatus());
                    }
                }
                if (Status.isStatusFinished(RemoteFlowWatcher.this.flow.getStatus())) {
                    RemoteFlowWatcher.this.isShutdown = true;
                    continue;
                }
                RemoteUpdaterThread remoteUpdaterThread = this;
                synchronized (remoteUpdaterThread) {
                    try {
                        this.wait(RemoteFlowWatcher.this.checkIntervalMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (!RemoteFlowWatcher.this.isShutdown);
        }
    }
}

