/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor;

import azkaban.jobExecutor.AbstractProcessJob;
import azkaban.jobExecutor.utils.process.AzkabanProcess;
import azkaban.jobExecutor.utils.process.AzkabanProcessBuilder;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ProcessJob
extends AbstractProcessJob {
    public static final String COMMAND = "command";
    private static final long KILL_TIME_MS = 5000L;
    private volatile AzkabanProcess process;

    public ProcessJob(String jobId, Props sysProps, Props jobProps, Logger log) {
        super(jobId, sysProps, jobProps, log);
    }

    /*
     * Unable to fully structure code
     */
    public void run() throws Exception {
        try {
            this.resolveProps();
        }
        catch (Exception e) {
            this.handleError("Bad property definition! " + e.getMessage(), e);
        }
        commands = null;
        try {
            commands = this.getCommandList();
        }
        catch (Exception e) {
            this.handleError("Job set up failed " + e.getCause(), e);
        }
        startMs = System.currentTimeMillis();
        if (commands == null) {
            this.handleError("There are no commands to execute", null);
        }
        this.info(String.valueOf(commands.size()) + " commands to execute.");
        propFiles = this.initPropsFiles();
        envVars = this.getEnvironmentVariables();
        for (String command : commands) {
            block13: {
                this.info("Command: " + command);
                builder = new AzkabanProcessBuilder(ProcessJob.partitionCommandLine((String)command)).setEnv(envVars).setWorkingDir(this.getCwd()).setLogger(this.getLog());
                if (builder.getEnv().size() > 0) {
                    this.info("Environment variables: " + builder.getEnv());
                }
                this.info("Working directory: " + builder.getWorkingDir());
                success = false;
                this.process = builder.build();
                try {
                    try {
                        this.process.run();
                        success = true;
                        break block13;
                    }
                    catch (Throwable e) {
                        var14_12 = propFiles;
                        var13_13 = propFiles.length;
                        var12_14 = 0;
                        ** while (var12_14 < var13_13)
                    }
lbl-1000:
                    // 1 sources

                    {
                        file = var14_12[var12_14];
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                        ++var12_14;
                        continue;
                    }
lbl42:
                    // 1 sources

                    throw new RuntimeException(e);
                }
                catch (Throwable var15_16) {
                    this.process = null;
                    this.info("Process completed " + (success != false ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
                    throw var15_16;
                }
            }
            this.process = null;
            this.info("Process completed " + (success != false ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
        }
        this.generateProperties(propFiles[1]);
    }

    protected void handleError(String errorMsg, Exception e) throws Exception {
        this.error(errorMsg);
        if (e != null) {
            throw new Exception(errorMsg, e);
        }
        throw new Exception(errorMsg);
    }

    protected List<String> getCommandList() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.jobProps.getString(COMMAND));
        int i = 1;
        while (this.jobProps.containsKey((Object)("command." + i))) {
            commands.add(this.jobProps.getString("command." + i));
            ++i;
        }
        return commands;
    }

    public void cancel() throws InterruptedException {
        if (this.process == null) {
            throw new IllegalStateException("Not started.");
        }
        boolean killed = this.process.softKill(5000L, TimeUnit.MILLISECONDS);
        if (!killed) {
            this.warn("Kill with signal TERM failed. Killing with KILL signal.");
            this.process.hardKill();
        }
    }

    public double getProgress() {
        return this.process != null && this.process.isComplete() ? 1.0 : 0.0;
    }

    public int getProcessId() {
        return this.process.getProcessId();
    }

    public String getPath() {
        return this._jobPath == null ? "" : this._jobPath;
    }

    public static String[] partitionCommandLine(String command) {
        ArrayList<String> commands = new ArrayList<String>();
        int index = 0;
        StringBuffer buffer = new StringBuffer(command.length());
        boolean isApos = false;
        boolean isQuote = false;
        while (index < command.length()) {
            char c = command.charAt(index);
            switch (c) {
                case ' ': {
                    if (!isQuote && !isApos) {
                        String arg = buffer.toString();
                        buffer = new StringBuffer(command.length() - index);
                        if (arg.length() <= 0) break;
                        commands.add(arg);
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case '\'': {
                    if (!isQuote) {
                        isApos = !isApos;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case '\"': {
                    if (!isApos) {
                        isQuote = !isQuote;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++index;
        }
        if (buffer.length() > 0) {
            String arg = buffer.toString();
            commands.add(arg);
        }
        return commands.toArray(new String[commands.size()]);
    }
}

