/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListWrapper
extends AbstractList<Object> {
    private final Object array;

    public ArrayListWrapper(Object anArray) {
        if (!anArray.getClass().isArray()) {
            throw new IllegalArgumentException(anArray.getClass() + " is not an array");
        }
        this.array = anArray;
    }

    @Override
    public Object get(int index) {
        return Array.get(this.array, index);
    }

    @Override
    public Object set(int index, Object element) {
        Object old = this.get(index);
        Array.set(this.array, index, element);
        return old;
    }

    @Override
    public int size() {
        return Array.getLength(this.array);
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] a = new Object[size];
        for (int i = 0; i < size; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            Object[] x = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            System.arraycopy(a, a.length, x, 0, a.length);
        }
        for (int i = 0; i < size; ++i) {
            a[i] = this.get(i);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public int indexOf(Object o) {
        int size = this.size();
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return super.iterator();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public int lastIndexOf(Object o) {
        return super.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return super.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return super.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

