/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.DataTypeFactory;
import org.h2.mvstore.type.ObjectTypeFactory;
import org.h2.mvstore.type.StringType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.New;

public class MVStore {
    public static final boolean ASSERT = false;
    static final int BLOCK_SIZE = 4096;
    private final HashMap<String, Object> config;
    private final String fileName;
    private final DataTypeFactory dataTypeFactory;
    private int pageSize = 6144;
    private FileChannel file;
    private FileLock fileLock;
    private long fileSize;
    private long rootChunkStart;
    private final CacheLongKeyLIRS<Page> cache;
    private int lastChunkId;
    private final HashMap<Integer, Chunk> chunks = New.hashMap();
    private final HashMap<Long, HashMap<Integer, Chunk>> freedChunks = New.hashMap();
    private MVMap<String, String> meta;
    private final HashMap<String, MVMap<?, ?>> maps = New.hashMap();
    private final HashMap<Integer, MVMap<?, ?>> mapsChanged = New.hashMap();
    private HashMap<String, String> fileHeader = New.hashMap();
    private final boolean readOnly;
    private int lastMapId;
    private volatile boolean reuseSpace = true;
    private long retainVersion = -1L;
    private int retainChunk = -1;
    private Compressor compressor;
    private long currentVersion;
    private int fileReadCount;
    private int fileWriteCount;
    private int unsavedPageCount;

    MVStore(HashMap<String, Object> hashMap) {
        this.config = hashMap;
        this.fileName = (String)hashMap.get("fileName");
        ObjectTypeFactory objectTypeFactory = new ObjectTypeFactory();
        DataTypeFactory dataTypeFactory = (DataTypeFactory)hashMap.get("dataTypeFactory");
        if (dataTypeFactory == null) {
            dataTypeFactory = objectTypeFactory;
        } else {
            dataTypeFactory.setParent(objectTypeFactory);
        }
        this.dataTypeFactory = dataTypeFactory;
        this.readOnly = "r".equals(hashMap.get("openMode"));
        Compressor compressor = this.compressor = "0".equals(hashMap.get("compression")) ? null : new CompressLZF();
        if (this.fileName != null) {
            Object object = hashMap.get("cacheSize");
            int n = object == null ? 16 : Integer.parseInt(object.toString());
            this.cache = CacheLongKeyLIRS.newInstance(n * 1024 * 1024, 2048, 16, n * 1024 * 1024 / 2048 * 2 / 100);
        } else {
            this.cache = null;
        }
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("fileName", string);
        MVStore mVStore = new MVStore(hashMap);
        mVStore.open();
        return mVStore;
    }

    <T extends MVMap<?, ?>> T openMapVersion(long l, String string, MVMap<?, ?> mVMap) {
        MVMap<String, String> mVMap2 = this.getMetaMap(l);
        String string2 = mVMap2.get("root." + mVMap.getId());
        long l2 = string2 == null ? 0L : Long.parseLong(string2);
        MVMap<?, ?> mVMap3 = mVMap.openReadOnly();
        mVMap3.setRootPos(l2, l);
        return (T)mVMap3;
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, Object.class, Object.class);
    }

    public <K, V> MVMap<K, V> openMap(String string, Class<K> clazz, Class<V> clazz2) {
        DataType dataType = this.getDataType(clazz);
        DataType dataType2 = this.getDataType(clazz2);
        MVMap mVMap = new MVMap(dataType, dataType2);
        return this.openMap(string, mVMap);
    }

    public <T extends MVMap<K, V>, K, V> T openMap(String string, T t) {
        long l;
        HashMap<Object, Object> hashMap;
        MVMap<Object, Object> mVMap = this.maps.get(string);
        if (mVMap != null) {
            return (T)mVMap;
        }
        mVMap = t;
        String string2 = this.meta.get("map." + string);
        if (string2 == null) {
            hashMap = New.hashMap();
            hashMap.put("id", Integer.toString(++this.lastMapId));
            hashMap.put("name", string);
            hashMap.put("createVersion", Long.toString(this.currentVersion));
            mVMap.open(this, hashMap);
            this.meta.put("map." + string, mVMap.asString());
            l = 0L;
        } else {
            hashMap = DataUtils.parseMap(string2);
            String string3 = this.meta.get("root." + (String)hashMap.get("id"));
            l = string3 == null ? 0L : Long.parseLong(string3);
        }
        mVMap.open(this, hashMap);
        mVMap.setRootPos(l, -1L);
        this.maps.put(string, mVMap);
        return (T)mVMap;
    }

    public MVMap<String, String> getMetaMap() {
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            throw new IllegalArgumentException("Unknown version: " + l);
        }
        chunk = this.readChunkHeader(chunk.start);
        MVMap<String, String> mVMap = this.meta.openReadOnly();
        mVMap.setRootPos(chunk.metaRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        int n = this.lastChunkId;
        Chunk chunk;
        while ((chunk = this.chunks.get(n)) != null && chunk.version >= l) {
            if (chunk.version == l) {
                return chunk;
            }
            --n;
        }
        return null;
    }

    void removeMap(String string) {
        MVMap<?, ?> mVMap = this.maps.remove(string);
        this.mapsChanged.remove(mVMap.getId());
    }

    private DataType getDataType(Class<?> clazz) {
        if (clazz == String.class) {
            return StringType.INSTANCE;
        }
        if (this.dataTypeFactory == null) {
            throw new RuntimeException("No data type factory set and don't know how to serialize " + clazz);
        }
        String string = this.dataTypeFactory.getDataType(clazz);
        return this.dataTypeFactory.buildDataType(string);
    }

    void markChanged(MVMap<?, ?> mVMap) {
        this.mapsChanged.put(mVMap.getId(), mVMap);
    }

    void open() {
        this.meta = new MVMap(StringType.INSTANCE, StringType.INSTANCE);
        HashMap<String, String> hashMap = New.hashMap();
        hashMap.put("id", "0");
        hashMap.put("name", "meta");
        hashMap.put("createVersion", Long.toString(this.currentVersion));
        this.meta.open(this, hashMap);
        if (this.fileName == null) {
            return;
        }
        FileUtils.createDirectories(FileUtils.getParent(this.fileName));
        try {
            this.log("file open");
            this.file = FilePathCache.wrap(FilePath.get(this.fileName).open("rw"));
            if (this.readOnly) {
                this.fileLock = this.file.tryLock(0L, Long.MAX_VALUE, true);
                if (this.fileLock == null) {
                    throw new RuntimeException("The file is locked: " + this.fileName);
                }
            } else {
                this.fileLock = this.file.tryLock();
                if (this.fileLock == null) {
                    throw new RuntimeException("The file is locked: " + this.fileName);
                }
            }
            this.fileSize = this.file.size();
            if (this.fileSize == 0L) {
                this.fileHeader.put("H", "3");
                this.fileHeader.put("blockSize", "4096");
                this.fileHeader.put("format", "1");
                this.fileHeader.put("formatRead", "1");
                this.writeFileHeader();
            } else {
                this.readFileHeader();
                if (this.rootChunkStart > 0L) {
                    this.readMeta();
                }
            }
        }
        catch (Exception exception) {
            this.close();
            throw MVStore.convert(exception);
        }
    }

    private void readMeta() {
        String string;
        Chunk chunk = this.readChunkHeader(this.rootChunkStart);
        this.lastChunkId = chunk.id;
        this.chunks.put(chunk.id, chunk);
        this.meta.setRootPos(chunk.metaRootPos, -1L);
        Cursor<String> cursor = this.meta.keyIterator("chunk.");
        while (cursor.hasNext() && (string = (String)cursor.next()).startsWith("chunk.")) {
            Chunk chunk2 = Chunk.fromString(this.meta.get(string));
            if (chunk2.id == chunk.id) {
                chunk2.start = chunk.start;
                chunk2.length = chunk.length;
                chunk2.metaRootPos = chunk.metaRootPos;
                chunk2.maxLengthLive = chunk.maxLengthLive;
                chunk2.pageCount = chunk.pageCount;
                chunk2.maxLength = chunk.maxLength;
            }
            this.lastChunkId = Math.max(chunk2.id, this.lastChunkId);
            this.chunks.put(chunk2.id, chunk2);
        }
    }

    private void readFileHeader() {
        try {
            byte[] byArray = new byte[8192];
            ++this.fileReadCount;
            DataUtils.readFully(this.file, 0L, ByteBuffer.wrap(byArray));
            for (int i = 0; i <= 4096; i += 4096) {
                byte[] byArray2;
                int n;
                String string = new String(byArray, i, 4096, "UTF-8").trim();
                this.fileHeader = DataUtils.parseMap(string);
                this.rootChunkStart = Long.parseLong(this.fileHeader.get("rootChunk"));
                this.currentVersion = Long.parseLong(this.fileHeader.get("version"));
                this.lastMapId = Integer.parseInt(this.fileHeader.get("lastMapId"));
                int n2 = (int)Long.parseLong(this.fileHeader.get("fletcher"), 16);
                if (n2 != (n = DataUtils.getFletcher32(byArray2 = (string = string.substring(0, string.lastIndexOf("fletcher") - 1) + " ").getBytes("UTF-8"), byArray2.length / 2 * 2))) continue;
                return;
            }
            throw new RuntimeException("File header is corrupt");
        }
        catch (Exception exception) {
            throw MVStore.convert(exception);
        }
    }

    private void writeFileHeader() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            this.fileHeader.put("lastMapId", "" + this.lastMapId);
            this.fileHeader.put("rootChunk", "" + this.rootChunkStart);
            this.fileHeader.put("version", "" + this.currentVersion);
            DataUtils.appendMap(stringBuilder, this.fileHeader);
            byte[] byArray = (stringBuilder.toString() + " ").getBytes("UTF-8");
            int n = DataUtils.getFletcher32(byArray, byArray.length / 2 * 2);
            DataUtils.appendMap(stringBuilder, "fletcher", Integer.toHexString(n));
            byArray = stringBuilder.toString().getBytes("UTF-8");
            if (byArray.length > 4096) {
                throw new IllegalArgumentException("File header too large: " + stringBuilder);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            byteBuffer.put(byArray);
            byteBuffer.position(4096);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            ++this.fileWriteCount;
            DataUtils.writeFully(this.file, 0L, byteBuffer);
            this.fileSize = Math.max(this.fileSize, 8192L);
        }
        catch (Exception exception) {
            throw MVStore.convert(exception);
        }
    }

    private static RuntimeException convert(Exception exception) {
        throw new RuntimeException("Exception: " + exception, exception);
    }

    public void close() {
        if (this.file != null) {
            try {
                this.shrinkFileIfPossible(0);
                this.log("file close");
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.file.close();
                for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
                    mVMap.close();
                }
                this.meta = null;
                this.compressor = null;
                this.chunks.clear();
                this.cache.clear();
                this.maps.clear();
                this.mapsChanged.clear();
            }
            catch (Exception exception) {
                throw MVStore.convert(exception);
            }
            finally {
                this.file = null;
            }
        }
    }

    Chunk getChunk(long l) {
        return this.chunks.get(DataUtils.getPageChunkId(l));
    }

    public long incrementVersion() {
        return ++this.currentVersion;
    }

    public long store() {
        MVMap<?, ?> mVMap22;
        if (!this.hasUnsavedChanges()) {
            return this.currentVersion;
        }
        int n = this.unsavedPageCount;
        long l = this.currentVersion;
        long l2 = this.incrementVersion();
        Chunk chunk = this.chunks.get(this.lastChunkId);
        if (chunk != null) {
            this.meta.put("chunk." + chunk.id, chunk.asString());
        }
        chunk = new Chunk(++this.lastChunkId);
        chunk.maxLength = Long.MAX_VALUE;
        chunk.maxLengthLive = Long.MAX_VALUE;
        chunk.start = Long.MAX_VALUE;
        chunk.length = Integer.MAX_VALUE;
        chunk.version = l2;
        this.chunks.put(chunk.id, chunk);
        this.meta.put("chunk." + chunk.id, chunk.asString());
        int n2 = 17;
        for (MVMap<?, ?> mVMap22 : this.mapsChanged.values()) {
            if (mVMap22 == this.meta || !mVMap22.hasUnsavedChanges()) continue;
            Page object = mVMap22.openVersion(l).getRoot();
            if (object.getTotalCount() == 0L) {
                this.meta.put("root." + mVMap22.getId(), "0");
                continue;
            }
            n2 += object.getMaxLengthTempRecursive();
            this.meta.put("root." + mVMap22.getId(), String.valueOf(Long.MAX_VALUE));
        }
        this.applyFreedChunks();
        ArrayList arrayList = New.arrayList();
        do {
            for (Chunk chunk2 : this.chunks.values()) {
                if (chunk2.maxLengthLive == 0L && (this.retainChunk == -1 || chunk2.id < this.retainChunk)) {
                    this.meta.remove("chunk." + chunk2.id);
                    arrayList.add(chunk2.id);
                } else {
                    this.meta.put("chunk." + chunk2.id, chunk2.asString());
                }
                this.applyFreedChunks();
            }
        } while (this.freedChunks.size() > 0);
        mVMap22 = ByteBuffer.allocate(n2 += this.meta.getRoot().getMaxLengthTempRecursive());
        chunk.writeHeader((ByteBuffer)((Object)mVMap22));
        chunk.maxLength = 0L;
        chunk.maxLengthLive = 0L;
        for (MVMap<?, ?> mVMap : this.mapsChanged.values()) {
            Page page;
            if (mVMap == this.meta || !mVMap.hasUnsavedChanges() || (page = mVMap.openVersion(l).getRoot()).getTotalCount() <= 0L) continue;
            long l3 = page.writeUnsavedRecursive(chunk, (ByteBuffer)((Object)mVMap22));
            this.meta.put("root." + mVMap.getId(), "" + l3);
        }
        this.meta.put("chunk." + chunk.id, chunk.asString());
        this.meta.getRoot().writeUnsavedRecursive(chunk, (ByteBuffer)((Object)mVMap22));
        ((ByteBuffer)((Object)mVMap22)).flip();
        int n3 = ((Buffer)((Object)mVMap22)).limit();
        long l4 = this.allocateChunk(n3);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            this.chunks.remove(n4);
        }
        ((ByteBuffer)((Object)mVMap22)).rewind();
        chunk.start = l4;
        chunk.length = n3;
        chunk.metaRootPos = this.meta.getRoot().getPos();
        chunk.writeHeader((ByteBuffer)((Object)mVMap22));
        ((ByteBuffer)((Object)mVMap22)).rewind();
        try {
            ++this.fileWriteCount;
            DataUtils.writeFully(this.file, l4, (ByteBuffer)((Object)mVMap22));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.fileSize = Math.max(this.fileSize, l4 + (long)((Buffer)((Object)mVMap22)).position());
        this.rootChunkStart = l4;
        this.revertTemp();
        this.writeFileHeader();
        this.shrinkFileIfPossible(1);
        this.unsavedPageCount = Math.max(0, this.unsavedPageCount - n);
        return l2;
    }

    private void applyFreedChunks() {
        for (HashMap<Integer, Chunk> hashMap : this.freedChunks.values()) {
            for (Chunk chunk : hashMap.values()) {
                Chunk chunk2 = this.chunks.get(chunk.id);
                chunk2.maxLengthLive += chunk.maxLengthLive;
                if (chunk2.maxLengthLive >= 0L) continue;
                throw new RuntimeException("Corrupt max length");
            }
        }
        this.freedChunks.clear();
    }

    private void shrinkFileIfPossible(int n) {
        long l = this.getFileLengthUsed();
        try {
            if (l >= this.fileSize) {
                return;
            }
            if (n > 0 && this.fileSize - l < 4096L) {
                return;
            }
            int n2 = (int)(100L - l * 100L / this.fileSize);
            if (n2 < n) {
                return;
            }
            this.file.truncate(l);
            this.fileSize = l;
        }
        catch (Exception exception) {
            throw MVStore.convert(exception);
        }
    }

    private long getFileLengthUsed() {
        int n = 2;
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.start == Long.MAX_VALUE) continue;
            int n2 = (int)((chunk.start + (long)chunk.length) / 4096L);
            n = Math.max(n, n2 + 1);
        }
        return n * 4096;
    }

    private long allocateChunk(long l) {
        int n;
        int n2;
        if (!this.reuseSpace) {
            return this.getFileLengthUsed();
        }
        BitSet bitSet = new BitSet();
        bitSet.set(0);
        bitSet.set(1);
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.start == Long.MAX_VALUE) continue;
            n2 = (int)(chunk.start / 4096L);
            n = (int)((chunk.start + (long)chunk.length) / 4096L);
            bitSet.set(n2, n + 1);
        }
        int n3 = (int)(l / 4096L) + 1;
        for (int i = 0; i < bitSet.size(); ++i) {
            if (bitSet.get(i)) continue;
            n2 = 1;
            for (n = 0; n < n3; ++n) {
                if (!bitSet.get(i + n)) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            return i * 4096;
        }
        return bitSet.size() * 4096;
    }

    public boolean hasUnsavedChanges() {
        if (this.mapsChanged.size() == 0) {
            return false;
        }
        for (MVMap<?, ?> mVMap : this.mapsChanged.values()) {
            if (mVMap != this.meta && !mVMap.hasUnsavedChanges()) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long l) {
        try {
            ++this.fileReadCount;
            ByteBuffer byteBuffer = ByteBuffer.allocate(40);
            DataUtils.readFully(this.file, l, byteBuffer);
            byteBuffer.rewind();
            return Chunk.fromHeader(byteBuffer, l);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public boolean compact(int n) {
        int n2;
        if (this.chunks.size() == 0) {
            return false;
        }
        long l = 0L;
        long l2 = 0L;
        for (Chunk chunk : this.chunks.values()) {
            l += chunk.maxLength;
            l2 += chunk.maxLengthLive;
        }
        if (l <= 0L) {
            l = 1L;
        }
        if ((n2 = (int)(100L * l2 / l)) > n) {
            return false;
        }
        int n3 = (int)(l / (long)this.chunks.size());
        ArrayList<Chunk> arrayList = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (this.retainChunk != -1 && chunk.id >= this.retainChunk) continue;
            int n4 = this.lastChunkId - chunk.id + 1;
            chunk.collectPriority = chunk.getFillRate() / n4;
            arrayList.add(chunk);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                return new Integer(chunk.collectPriority).compareTo(chunk2.collectPriority);
            }
        });
        long l3 = 0L;
        Chunk iterator2 = null;
        for (Chunk iterator3 : arrayList) {
            if (iterator2 != null && l3 + iterator3.maxLengthLive > (long)n3) break;
            this.log(" chunk " + iterator3.id + " " + iterator3.getFillRate() + "% full; prio=" + iterator3.collectPriority);
            l3 += iterator3.maxLengthLive;
            iterator2 = iterator3;
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            if (iterator2 == chunk) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            iterator.remove();
        }
        for (Chunk chunk : arrayList) {
            this.copyLive(chunk, arrayList);
        }
        this.store();
        return true;
    }

    private void copyLive(Chunk chunk, ArrayList<Chunk> arrayList) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(chunk.length);
        try {
            DataUtils.readFully(this.file, chunk.start, byteBuffer);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Chunk.fromHeader(byteBuffer, chunk.start);
        int n = chunk.length;
        this.markChanged(this.meta);
        while (byteBuffer.position() < n) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.getInt();
            byteBuffer.getShort();
            int n4 = DataUtils.readVarInt(byteBuffer);
            MVMap<?, ?> mVMap = this.getMap(n4);
            if (mVMap == null) {
                byteBuffer.position(n2 + n3);
                continue;
            }
            byteBuffer.position(n2);
            Page page = new Page(mVMap, 0L);
            page.read(byteBuffer, chunk.id, byteBuffer.position(), chunk.length);
            for (int i = 0; i < page.getKeyCount(); ++i) {
                Chunk chunk2;
                Object object = page.getKey(i);
                Page page2 = mVMap.getPage(object);
                if (page2 == null || page2.getPos() < 0L || !arrayList.contains(chunk2 = this.getChunk(page2.getPos()))) continue;
                this.log("       move key:" + object + " chunk:" + chunk2.id);
                Object obj = mVMap.remove(object);
                mVMap.put(object, obj);
            }
        }
    }

    private MVMap<?, ?> getMap(int n) {
        if (n == 0) {
            return this.meta;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            if (mVMap.getId() != n) continue;
            return mVMap;
        }
        return null;
    }

    Page readPage(MVMap<?, ?> mVMap, long l) {
        Page page = this.cache.get(l);
        if (page == null) {
            Chunk chunk = this.getChunk(l);
            if (chunk == null) {
                throw new RuntimeException("Chunk " + DataUtils.getPageChunkId(l) + " not found");
            }
            long l2 = chunk.start;
            ++this.fileReadCount;
            page = Page.read(this.file, mVMap, l, l2 += (long)DataUtils.getPageOffset(l), this.fileSize);
            this.cache.put(l, page, page.getMemory());
        }
        return page;
    }

    void removePage(long l) {
        Chunk chunk;
        if (l == 0L) {
            --this.unsavedPageCount;
            return;
        }
        this.cache.remove(l);
        Chunk chunk2 = this.getChunk(l);
        HashMap<Integer, Chunk> hashMap = this.freedChunks.get(this.currentVersion);
        if (hashMap == null) {
            hashMap = New.hashMap();
            this.freedChunks.put(this.currentVersion, hashMap);
        }
        if ((chunk = hashMap.get(chunk2.id)) == null) {
            chunk = new Chunk(chunk2.id);
            hashMap.put(chunk2.id, chunk);
        }
        chunk.maxLengthLive -= (long)DataUtils.getPageMaxLength(l);
    }

    void log(String string) {
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    Compressor getCompressor() {
        return this.compressor;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetainChunk() {
        return this.retainChunk;
    }

    public void setRetainChunk(int n) {
        this.retainChunk = n;
    }

    public void setRetainVersion(long l) {
        this.retainVersion = l;
    }

    public long getRetainVersion() {
        return this.retainVersion;
    }

    private boolean isKnownVersion(long l) {
        String string;
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.size() == 0) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l);
        if (mVMap == null) {
            return false;
        }
        Cursor<String> cursor = mVMap.keyIterator("chunk.");
        while (cursor.hasNext() && (string = (String)cursor.next()).startsWith("chunk.")) {
            if (this.meta.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    public int getUnsavedPageCount() {
        return this.unsavedPageCount;
    }

    void registerUnsavedPage() {
        ++this.unsavedPageCount;
    }

    public int getStoreVersion() {
        String string = this.meta.get("setting.storeVersion");
        return string == null ? 0 : Integer.parseInt(string);
    }

    public void setStoreVersion(int n) {
        this.meta.put("setting.storeVersion", Integer.toString(n));
    }

    public void rollbackTo(long l) {
        if (!this.isKnownVersion(l)) {
            throw new IllegalArgumentException("Unknown version: " + l);
        }
        for (MVMap<?, ?> object2 : this.mapsChanged.values()) {
            object2.rollbackTo(l);
        }
        for (long i = this.currentVersion; i >= l && this.freedChunks.size() != 0; --i) {
            this.freedChunks.remove(i);
        }
        this.meta.rollbackTo(l);
        boolean bl = false;
        Chunk chunk = this.chunks.get(this.lastChunkId);
        if (chunk != null && chunk.version >= l) {
            Chunk chunk2;
            this.revertTemp();
            bl = true;
            do {
                chunk2 = this.chunks.remove(this.lastChunkId);
                --this.lastChunkId;
            } while (chunk2.version > l && this.chunks.size() > 0);
            this.rootChunkStart = chunk2.start;
            this.writeFileHeader();
            this.readFileHeader();
            this.readMeta();
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            if (mVMap.getCreateVersion() >= l) {
                mVMap.close();
                this.removeMap(mVMap.getName());
                continue;
            }
            if (!bl) continue;
            String string = this.meta.get("root." + mVMap.getId());
            long l2 = string == null ? 0L : Long.parseLong(string);
            mVMap.setRootPos(l2, l);
        }
        this.currentVersion = l;
    }

    private void revertTemp() {
        this.freedChunks.clear();
        for (MVMap<?, ?> mVMap : this.mapsChanged.values()) {
            mVMap.removeAllOldVersions();
        }
        this.mapsChanged.clear();
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public int getFileWriteCount() {
        return this.fileWriteCount;
    }

    public int getFileReadCount() {
        return this.fileReadCount;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Map<String, String> getFileHeader() {
        return this.fileHeader;
    }

    public FileChannel getFile() {
        return this.file;
    }

    public String toString() {
        return DataUtils.appendMap(new StringBuilder(), this.config).toString();
    }
}

