/*
 * Decompiled with CFR 0.152.
 */
package azkaban.sla;

import azkaban.sla.SLA;
import azkaban.sla.SLALoader;
import azkaban.sla.SLAManagerException;
import azkaban.utils.DataSourceUtils;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class JdbcSLALoader
implements SLALoader {
    private static final Logger logger = Logger.getLogger(JdbcSLALoader.class);
    private DataSource dataSource;
    private EncodingType defaultEncodingType = EncodingType.GZIP;
    private static String slaTblName = "active_sla";
    private static final String LOAD_ALL_SLA = "SELECT exec_id, job_name, check_time, rule, enc_type, options FROM " + slaTblName;
    private static final String INSERT_SLA = "INSERT INTO " + slaTblName + " ( exec_id, job_name, check_time, rule, enc_type, options) values (?,?,?,?,?,?)";
    private static final String REMOVE_SLA = "DELETE FROM " + slaTblName + " WHERE exec_id=? AND job_name=? AND check_time=? AND rule=?";

    public JdbcSLALoader(Props props) {
        String databaseType = props.getString("database.type");
        if (databaseType.equals("mysql")) {
            int port = props.getInt("mysql.port");
            String host = props.getString("mysql.host");
            String database = props.getString("mysql.database");
            String user = props.getString("mysql.user");
            String password = props.getString("mysql.password");
            int numConnections = props.getInt("mysql.numconnections");
            this.dataSource = DataSourceUtils.getMySQLDataSource(host, port, database, user, password, numConnections);
        }
    }

    private Connection getConnection() throws SLAManagerException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (Exception e) {
            DbUtils.closeQuietly((Connection)connection);
            throw new SLAManagerException("Error getting DB connection.", e);
        }
        return connection;
    }

    public EncodingType getDefaultEncodingType() {
        return this.defaultEncodingType;
    }

    public void setDefaultEncodingType(EncodingType defaultEncodingType) {
        this.defaultEncodingType = defaultEncodingType;
    }

    @Override
    public List<SLA> loadSLAs() throws SLAManagerException {
        List<SLA> SLAs;
        logger.info((Object)"Loading all SLAs from db.");
        Connection connection = this.getConnection();
        try {
            SLAs = this.loadSLAs(connection, this.defaultEncodingType);
        }
        catch (SLAManagerException e) {
            throw new SLAManagerException("Failed to load SLAs" + e.getCause());
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        logger.info((Object)("Loaded " + SLAs.size() + " SLAs."));
        return SLAs;
    }

    public List<SLA> loadSLAs(Connection connection, EncodingType encType) throws SLAManagerException {
        List SLAs;
        logger.info((Object)"Loading all SLAs from db.");
        QueryRunner runner = new QueryRunner();
        SLAResultHandler handler = new SLAResultHandler();
        try {
            SLAs = (List)runner.query(connection, LOAD_ALL_SLA, (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            logger.error((Object)(LOAD_ALL_SLA + " failed."));
            throw new SLAManagerException("Load SLAs from db failed. " + e.getCause());
        }
        return SLAs;
    }

    @Override
    public void removeSLA(SLA s) throws SLAManagerException {
        Connection connection = this.getConnection();
        try {
            this.removeSLA(connection, s);
        }
        catch (SLAManagerException e) {
            logger.error((Object)(LOAD_ALL_SLA + " failed."));
            throw new SLAManagerException("Load SLAs from db failed. " + e.getCause());
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void removeSLA(Connection connection, SLA s) throws SLAManagerException {
        logger.info((Object)("Removing SLA " + s.toString() + " from db."));
        QueryRunner runner = new QueryRunner(this.dataSource);
        try {
            int removes = runner.update(REMOVE_SLA, new Object[]{s.getExecId(), s.getJobName(), s.getCheckTime().getMillis(), s.getRule().getNumVal()});
            if (removes == 0) {
                throw new SLAManagerException("No schedule has been removed.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Remove SLA failed. " + s.toString()));
            throw new SLAManagerException("Remove SLA " + s.toString() + " from db failed. " + e.getCause());
        }
    }

    @Override
    public void insertSLA(SLA s) throws SLAManagerException {
        Connection connection = this.getConnection();
        try {
            this.insertSLA(connection, s, this.defaultEncodingType);
        }
        catch (SLAManagerException e) {
            logger.error((Object)("Insert SLA failed. " + s.toString()));
            throw new SLAManagerException("Insert SLA " + s.toString() + " into db failed. " + e.getCause() + e.getMessage() + e.getStackTrace());
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void insertSLA(Connection connection, SLA s, EncodingType encType) throws SLAManagerException {
        logger.debug((Object)("Inserting new SLA into DB. " + s.toString()));
        QueryRunner runner = new QueryRunner();
        String json = JSONUtils.toJSON(s.optionToObject());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes(stringData);
            }
            logger.debug((Object)("NumChars: " + json.length() + " UTF-8:" + stringData.length + " Gzip:" + data.length));
        }
        catch (IOException e) {
            throw new SLAManagerException("Error encoding the sla options.");
        }
        try {
            int inserts = runner.update(connection, INSERT_SLA, new Object[]{s.getExecId(), s.getJobName(), s.getCheckTime().getMillis(), s.getRule().getNumVal(), encType.getNumVal(), data});
            if (inserts == 0) {
                throw new SLAManagerException("No SLA has been inserted. Insertion failed.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Insert SLA failed.");
            throw new SLAManagerException("Insert sla " + s.toString() + " into db failed. " + e.getCause());
        }
    }

    public class SLAResultHandler
    implements ResultSetHandler<List<SLA>> {
        public List<SLA> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<SLA> SLAs = new ArrayList<SLA>();
            do {
                int execId = rs.getInt(1);
                String jobName = rs.getString(2);
                DateTime checkTime = new DateTime(rs.getLong(3));
                SLA.SlaRule rule = SLA.SlaRule.fromInteger(rs.getInt(4));
                int encodingType = rs.getInt(5);
                byte[] data = rs.getBytes(6);
                SLA s = null;
                EncodingType encType = EncodingType.fromInteger(encodingType);
                try {
                    Object optsObj;
                    String jsonString;
                    if (encType == EncodingType.GZIP) {
                        jsonString = GZIPUtils.unGzipString(data, "UTF-8");
                        optsObj = JSONUtils.parseJSONFromString(jsonString);
                    } else {
                        jsonString = new String(data, "UTF-8");
                        optsObj = JSONUtils.parseJSONFromString(jsonString);
                    }
                    s = SLA.createSlaFromObject(execId, jobName, checkTime, rule, optsObj);
                }
                catch (IOException e) {
                    throw new SQLException("Error reconstructing SLA options. " + execId + " " + jobName + " " + checkTime.toDateTimeISO() + e.getCause());
                }
                SLAs.add(s);
            } while (rs.next());
            return SLAs;
        }
    }

    public static enum EncodingType {
        PLAIN(1),
        GZIP(2);

        private int numVal;

        private EncodingType(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static EncodingType fromInteger(int x) {
            switch (x) {
                case 1: {
                    return PLAIN;
                }
                case 2: {
                    return GZIP;
                }
            }
            return PLAIN;
        }
    }
}

