/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;

public class DataSourceUtils {
    public static DataSource getMySQLDataSource(String host, Integer port, String dbName, String user, String password, Integer numConnections) {
        return new MySQLBasicDataSource(host, port, dbName, user, password, numConnections);
    }

    private DataSourceUtils() {
    }

    public static void testConnection(DataSource ds) throws SQLException {
        QueryRunner runner = new QueryRunner(ds);
        runner.update("SHOW TABLES");
    }

    public static void testMySQLConnection(String host, Integer port, String dbName, String user, String password, Integer numConnections) throws SQLException {
        MySQLBasicDataSource ds = new MySQLBasicDataSource(host, port, dbName, user, password, numConnections);
        DataSourceUtils.testConnection((DataSource)((Object)ds));
    }

    public static class MySQLBasicDataSource
    extends BasicDataSource {
        private MySQLBasicDataSource(String host, int port, String dbName, String user, String password, int numConnections) {
            String url = "jdbc:mysql://" + host + ":" + port + "/" + dbName;
            this.setDriverClassName("com.mysql.jdbc.Driver");
            this.setUsername(user);
            this.setPassword(password);
            this.setUrl(url);
            this.setMaxActive(numConnections);
            this.setValidationQuery("/* ping */ select 1");
            this.setTestOnBorrow(true);
        }
    }
}

