/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDataSource;
import azkaban.utils.Props;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;

public class DataSourceUtils {
    public static AzkabanDataSource getDataSource(Props props) {
        String databaseType = props.getString("database.type");
        AzkabanDataSource dataSource = null;
        if (databaseType.equals("mysql")) {
            int port = props.getInt("mysql.port");
            String host = props.getString("mysql.host");
            String database = props.getString("mysql.database");
            String user = props.getString("mysql.user");
            String password = props.getString("mysql.password");
            int numConnections = props.getInt("mysql.numconnections");
            dataSource = DataSourceUtils.getMySQLDataSource(host, port, database, user, password, numConnections);
        } else if (databaseType.equals("h2")) {
            String path = props.getString("h2.path");
            dataSource = DataSourceUtils.getH2DataSource(path);
        }
        return dataSource;
    }

    public static AzkabanDataSource getMySQLDataSource(String host, Integer port, String dbName, String user, String password, Integer numConnections) {
        return new MySQLBasicDataSource(host, port, dbName, user, password, numConnections);
    }

    public static AzkabanDataSource getH2DataSource(String file) {
        return new EmbeddedH2BasicDataSource(file);
    }

    private DataSourceUtils() {
    }

    public static void testConnection(DataSource ds) throws SQLException {
        QueryRunner runner = new QueryRunner(ds);
        runner.update("SHOW TABLES");
    }

    public static void testMySQLConnection(String host, Integer port, String dbName, String user, String password, Integer numConnections) throws SQLException {
        MySQLBasicDataSource ds = new MySQLBasicDataSource(host, port, dbName, user, password, numConnections);
        DataSourceUtils.testConnection((DataSource)((Object)ds));
    }

    public static class EmbeddedH2BasicDataSource
    extends AzkabanDataSource {
        private EmbeddedH2BasicDataSource(String filePath) {
            String url = "jdbc:h2:file:" + filePath;
            this.setDriverClassName("org.h2.Driver");
            this.setUrl(url);
        }

        @Override
        public boolean allowsOnDuplicateKey() {
            return false;
        }

        @Override
        public String getDBType() {
            return "h2";
        }
    }

    public static class MySQLBasicDataSource
    extends AzkabanDataSource {
        private MySQLBasicDataSource(String host, int port, String dbName, String user, String password, int numConnections) {
            String url = "jdbc:mysql://" + host + ":" + port + "/" + dbName;
            this.setDriverClassName("com.mysql.jdbc.Driver");
            this.setUsername(user);
            this.setPassword(password);
            this.setUrl(url);
            this.setMaxActive(numConnections);
            this.setValidationQuery("/* ping */ select 1");
            this.setTestOnBorrow(true);
        }

        @Override
        public boolean allowsOnDuplicateKey() {
            return true;
        }

        @Override
        public String getDBType() {
            return "mysql";
        }
    }

    public static enum PropertyType {
        DB(1);

        private int numVal;

        private PropertyType(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static PropertyType fromInteger(int x) {
            switch (x) {
                case 1: {
                    return DB;
                }
            }
            return DB;
        }
    }
}

