/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.project.Project;
import azkaban.utils.FileIOUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ExecutorManagerAdapter {
    public static final String LOCAL_MODE = "local";
    public static final String REMOTE_MODE = "remote";
    public static final String REMOTE_EXECUTOR_MANAGER_HOST = "remote.executor.manager.host";
    public static final String REMOTE_EXECUTOR_MANAGER_PORT = "remote.executor.manager.port";
    public static final String REMOTE_EXECUTOR_MANAGER_URL = "/executormanager";
    public static final String ACTION_GET_FLOW_LOG = "getFlowLog";
    public static final String ACTION_GET_JOB_LOG = "getJobLog";
    public static final String ACTION_CANCEL_FLOW = "cancelFlow";
    public static final String ACTION_SUBMIT_FLOW = "submitFlow";
    public static final String ACTION_RESUME_FLOW = "resumeFlow";
    public static final String ACTION_PAUSE_FLOW = "pauseFlow";
    public static final String ACTION_MODIFY_EXECUTION = "modifyExecution";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_GET_JMX = "getJMX";
    public static final String COMMAND_MODIFY_PAUSE_JOBS = "modifyPauseJobs";
    public static final String COMMAND_MODIFY_RESUME_JOBS = "modifyResumeJobs";
    public static final String COMMAND_MODIFY_RETRY_FAILURES = "modifyRetryFailures";
    public static final String COMMAND_MODIFY_RETRY_JOBS = "modifyRetryJobs";
    public static final String COMMAND_MODIFY_DISABLE_JOBS = "modifyDisableJobs";
    public static final String COMMAND_MODIFY_ENABLE_JOBS = "modifyEnableJobs";
    public static final String COMMAND_MODIFY_CANCEL_JOBS = "modifyCancelJobs";
    public static final String INFO_JMX_TYPE = "jmxType";
    public static final String INFO_JMX_DATA = "jmxData";
    public static final String INFO_ACTION = "action";
    public static final String INFO_TYPE = "type";
    public static final String INFO_EXEC_ID = "execId";
    public static final String INFO_EXEC_FLOW_JSON = "execFlowJson";
    public static final String INFO_PROJECT_ID = "projectId";
    public static final String INFO_FLOW_NAME = "flowName";
    public static final String INFO_JOB_NAME = "jobName";
    public static final String INFO_OFFSET = "offset";
    public static final String INFO_LENGTH = "length";
    public static final String INFO_ATTEMPT = "attempt";
    public static final String INFO_MODIFY_JOB_IDS = "modifyJobIds";
    public static final String INFO_MODIFY_COMMAND = "modifyCommand";
    public static final String INFO_MESSAGE = "message";
    public static final String INFO_ERROR = "error";
    public static final String INFO_UPDATE_TIME_LIST = "updateTimeList";
    public static final String INFO_EXEC_ID_LIST = "execIdList";
    public static final String INFO_UPDATES = "updates";
    public static final String INFO_USER_ID = "userId";
    public static final String INFO_LOG = "logData";

    public boolean isFlowRunning(int var1, String var2);

    public ExecutableFlow getExecutableFlow(int var1) throws ExecutorManagerException;

    public List<Integer> getRunningFlows(int var1, String var2);

    public List<ExecutableFlow> getRunningFlows() throws IOException;

    public List<ExecutableFlow> getRecentlyFinishedFlows();

    public List<ExecutableFlow> getExecutableFlows(Project var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(int var1, int var2) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(String var1, int var2, int var3) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(String var1, String var2, String var3, int var4, long var5, long var7, int var9, int var10) throws ExecutorManagerException;

    public int getExecutableFlows(int var1, String var2, int var3, int var4, List<ExecutableFlow> var5) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(int var1, String var2, int var3, int var4, Status var5) throws ExecutorManagerException;

    public List<ExecutableJobInfo> getExecutableJobs(Project var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public int getNumberOfJobExecutions(Project var1, String var2) throws ExecutorManagerException;

    public int getNumberOfExecutions(Project var1, String var2) throws ExecutorManagerException;

    public FileIOUtils.LogData getExecutableFlowLog(ExecutableFlow var1, int var2, int var3) throws ExecutorManagerException;

    public FileIOUtils.LogData getExecutionJobLog(ExecutableFlow var1, String var2, int var3, int var4, int var5) throws ExecutorManagerException;

    public List<Object> getExecutionJobStats(ExecutableFlow var1, String var2, int var3) throws ExecutorManagerException;

    public FileIOUtils.JobMetaData getExecutionJobMetaData(ExecutableFlow var1, String var2, int var3, int var4, int var5) throws ExecutorManagerException;

    public void cancelFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void resumeFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void pauseFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void pauseExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void resumeExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void retryFailures(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void retryExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void disableExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void enableExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void cancelExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public String submitExecutableFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public Map<String, Object> callExecutorJMX(String var1, String var2, String var3) throws IOException;

    public void shutdown();

    public Set<String> getAllActiveExecutorServerHosts();

    public Thread.State getExecutorManagerThreadState();

    public boolean isExecutorManagerThreadActive();

    public long getLastExecutorManagerThreadCheckTime();

    public Set<? extends String> getPrimaryServerHosts();
}

