/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor.utils.process;

import azkaban.jobExecutor.utils.process.AzkabanProcess;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AzkabanProcessBuilder {
    private List<String> cmd = new ArrayList();
    private Map<String, String> env = new HashMap();
    private String workingDir = System.getProperty("user.dir");
    private Logger logger = Logger.getLogger(AzkabanProcess.class);
    private int stdErrSnippetSize = 30;
    private int stdOutSnippetSize = 30;

    public AzkabanProcessBuilder(String ... command) {
        this.addArg(command);
    }

    public AzkabanProcessBuilder addArg(String ... command) {
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.cmd.add(c);
            ++n2;
        }
        return this;
    }

    public AzkabanProcessBuilder setWorkingDir(String dir) {
        this.workingDir = dir;
        return this;
    }

    public AzkabanProcessBuilder setWorkingDir(File f) {
        return this.setWorkingDir(f.getAbsolutePath());
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public AzkabanProcessBuilder addEnv(String variable, String value) {
        this.env.put(variable, value);
        return this;
    }

    public AzkabanProcessBuilder setEnv(Map<String, String> m) {
        this.env = m;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public AzkabanProcessBuilder setStdErrorSnippetSize(int size) {
        this.stdErrSnippetSize = size;
        return this;
    }

    public AzkabanProcessBuilder setStdOutSnippetSize(int size) {
        this.stdOutSnippetSize = size;
        return this;
    }

    public int getStdErrorSnippetSize() {
        return this.stdErrSnippetSize;
    }

    public int getStdOutSnippetSize() {
        return this.stdOutSnippetSize;
    }

    public AzkabanProcessBuilder setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public AzkabanProcess build() {
        return new AzkabanProcess(this.cmd, this.env, this.workingDir, this.logger);
    }

    public List<String> getCommand() {
        return this.cmd;
    }

    public String getCommandString() {
        return Joiner.on((String)" ").join((Iterable)this.getCommand());
    }

    public String toString() {
        return "ProcessBuilder(cmd = " + Joiner.on((String)" ").join((Iterable)this.cmd) + ", env = " + this.env + ", cwd = " + this.workingDir + ")";
    }
}

