/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.execapp;

import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class EventCollectorListener
implements EventListener {
    private ArrayList<Event> eventList = new ArrayList();
    private HashSet<Event.Type> filterOutTypes = new HashSet();

    public void setEventFilterOut(Event.Type ... types) {
        this.filterOutTypes.addAll(Arrays.asList(types));
    }

    public void handleEvent(Event event) {
        if (!this.filterOutTypes.contains(event.getType())) {
            this.eventList.add(event);
        }
    }

    public ArrayList<Event> getEventList() {
        return this.eventList;
    }

    public void writeAllEvents() {
        for (Event event : this.eventList) {
            System.out.print(event.getType());
            System.out.print(",");
        }
    }

    public boolean checkOrdering() {
        long time = 0L;
        for (Event event : this.eventList) {
            if (time <= event.getTime()) continue;
            return false;
        }
        return true;
    }

    public void checkEventExists(Event.Type[] types) {
        int index = 0;
        for (Event event : this.eventList) {
            Event.Type type;
            if (event.getRunner() == null) continue;
            if (index >= types.length) {
                throw new RuntimeException("More events than expected. Got " + event.getType());
            }
            if ((type = types[index++]) == event.getType()) continue;
            throw new RuntimeException("Got " + event.getType() + ", expected " + type + " index:" + index);
        }
        if (types.length != index) {
            throw new RuntimeException("Not enough events.");
        }
    }
}

