/*
 * Decompiled with CFR 0.152.
 */
package azkaban.flow;

import azkaban.utils.Props;
import java.util.HashMap;
import java.util.Map;

public class FlowProps {
    private String parentSource;
    private String propSource;
    private Props props = null;

    public FlowProps(String parentSource, String propSource) {
        this.parentSource = parentSource;
        this.propSource = propSource;
    }

    public FlowProps(Props props) {
        this.setProps(props);
    }

    public Props getProps() {
        return this.props;
    }

    public void setProps(Props props) {
        this.props = props;
        this.parentSource = props.getParent() == null ? null : props.getParent().getSource();
        this.propSource = props.getSource();
    }

    public String getSource() {
        return this.propSource;
    }

    public String getInheritedSource() {
        return this.parentSource;
    }

    public Object toObject() {
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("source", this.propSource);
        if (this.parentSource != null) {
            obj.put("inherits", this.parentSource);
        }
        return obj;
    }

    public static FlowProps fromObject(Object obj) {
        Map flowMap = (Map)obj;
        String source = (String)flowMap.get("source");
        String parentSource = (String)flowMap.get("inherits");
        FlowProps flowProps = new FlowProps(parentSource, source);
        return flowProps;
    }
}

