/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDataSource;
import azkaban.database.DataSourceUtils;
import azkaban.utils.Props;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataSourceUtils {
    private static Logger logger = Logger.getLogger(DataSourceUtils.class);

    public static AzkabanDataSource getDataSource(Props props) {
        String databaseType = props.getString("database.type");
        AzkabanDataSource dataSource = null;
        if (databaseType.equals("mysql")) {
            int port = props.getInt("mysql.port");
            String host = props.getString("mysql.host");
            String database = props.getString("mysql.database");
            String user = props.getString("mysql.user");
            String password = props.getString("mysql.password");
            int numConnections = props.getInt("mysql.numconnections");
            dataSource = DataSourceUtils.getMySQLDataSource((String)host, (Integer)port, (String)database, (String)user, (String)password, (Integer)numConnections);
        } else if (databaseType.equals("h2")) {
            String path = props.getString("h2.path");
            dataSource = DataSourceUtils.getH2DataSource((String)path);
        }
        return dataSource;
    }

    public static AzkabanDataSource getMySQLDataSource(String host, Integer port, String dbName, String user, String password, Integer numConnections) {
        return new MySQLBasicDataSource(host, port.intValue(), dbName, user, password, numConnections.intValue(), null);
    }

    public static AzkabanDataSource getH2DataSource(String file) {
        return new EmbeddedH2BasicDataSource(file, null);
    }

    private DataSourceUtils() {
    }

    public static void testConnection(DataSource ds) throws SQLException {
        QueryRunner runner = new QueryRunner(ds);
        runner.update("SHOW TABLES");
    }

    public static void testMySQLConnection(String host, Integer port, String dbName, String user, String password, Integer numConnections) throws SQLException {
        MySQLBasicDataSource ds = new MySQLBasicDataSource(host, port.intValue(), dbName, user, password, numConnections.intValue(), null);
        DataSourceUtils.testConnection((DataSource)ds);
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }
}

