/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.trigger;

import azkaban.database.AzkabanDataSource;
import azkaban.database.DataSourceUtils;
import azkaban.executor.ExecutionOptions;
import azkaban.test.trigger.JdbcTriggerLoaderTest;
import azkaban.trigger.ActionTypeLoader;
import azkaban.trigger.CheckerTypeLoader;
import azkaban.trigger.Condition;
import azkaban.trigger.JdbcTriggerLoader;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerException;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerLoaderException;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JdbcTriggerLoaderTest {
    private static boolean testDBExists = false;
    private static final String host = "localhost";
    private static final int port = 3306;
    private static final String database = "azkaban2";
    private static final String user = "azkaban";
    private static final String password = "azkaban";
    private static final int numConnections = 10;
    private TriggerLoader loader;
    private CheckerTypeLoader checkerLoader;
    private ActionTypeLoader actionLoader;

    @Before
    public void setup() throws TriggerException {
        Props props = new Props();
        props.put("database.type", "mysql");
        props.put("mysql.host", host);
        props.put("mysql.port", Integer.valueOf(3306));
        props.put("mysql.user", "azkaban");
        props.put("mysql.database", database);
        props.put("mysql.password", "azkaban");
        props.put("mysql.numconnections", Integer.valueOf(10));
        this.loader = new JdbcTriggerLoader(props);
        this.checkerLoader = new CheckerTypeLoader();
        this.checkerLoader.init(new Props());
        Condition.setCheckerLoader((CheckerTypeLoader)this.checkerLoader);
        this.actionLoader = new ActionTypeLoader();
        this.actionLoader.init(new Props());
        Trigger.setActionTypeLoader((ActionTypeLoader)this.actionLoader);
        this.setupDB();
    }

    public void setupDB() {
        AzkabanDataSource dataSource = DataSourceUtils.getMySQLDataSource((String)host, (Integer)3306, (String)database, (String)"azkaban", (String)"azkaban", (Integer)10);
        testDBExists = true;
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        CountHandler countHandler = new CountHandler();
        QueryRunner runner = new QueryRunner();
        try {
            runner.query(connection, "SELECT COUNT(1) FROM triggers", (ResultSetHandler)countHandler);
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        DbUtils.closeQuietly((Connection)connection);
        this.clearDB();
    }

    @After
    public void clearDB() {
        if (!testDBExists) {
            return;
        }
        AzkabanDataSource dataSource = DataSourceUtils.getMySQLDataSource((String)host, (Integer)3306, (String)database, (String)"azkaban", (String)"azkaban", (Integer)10);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, "DELETE FROM triggers");
        }
        catch (SQLException e) {
            e.printStackTrace();
            testDBExists = false;
            DbUtils.closeQuietly((Connection)connection);
            return;
        }
        DbUtils.closeQuietly((Connection)connection);
    }

    @Test
    public void addTriggerTest() throws TriggerLoaderException {
        Trigger t1 = this.createTrigger("testProj1", "testFlow1", "source1");
        Trigger t2 = this.createTrigger("testProj2", "testFlow2", "source2");
        this.loader.addTrigger(t1);
        List ts = this.loader.loadTriggers();
        Assert.assertTrue((ts.size() == 1 ? 1 : 0) != 0);
        Trigger t3 = (Trigger)ts.get(0);
        Assert.assertTrue((boolean)t3.getSource().equals("source1"));
        this.loader.addTrigger(t2);
        ts = this.loader.loadTriggers();
        Assert.assertTrue((ts.size() == 2 ? 1 : 0) != 0);
        for (Trigger t : ts) {
            if (t.getTriggerId() != t2.getTriggerId()) continue;
            t.getSource().equals(t2.getSource());
        }
    }

    @Test
    public void removeTriggerTest() throws TriggerLoaderException {
        Trigger t1 = this.createTrigger("testProj1", "testFlow1", "source1");
        Trigger t2 = this.createTrigger("testProj2", "testFlow2", "source2");
        this.loader.addTrigger(t1);
        this.loader.addTrigger(t2);
        List ts = this.loader.loadTriggers();
        Assert.assertTrue((ts.size() == 2 ? 1 : 0) != 0);
        this.loader.removeTrigger(t2);
        ts = this.loader.loadTriggers();
        Assert.assertTrue((ts.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Trigger)ts.get(0)).getTriggerId() == t1.getTriggerId() ? 1 : 0) != 0);
    }

    @Test
    public void updateTriggerTest() throws TriggerLoaderException {
        Trigger t1 = this.createTrigger("testProj1", "testFlow1", "source1");
        t1.setResetOnExpire(true);
        this.loader.addTrigger(t1);
        List ts = this.loader.loadTriggers();
        Assert.assertTrue((boolean)((Trigger)ts.get(0)).isResetOnExpire());
        t1.setResetOnExpire(false);
        this.loader.updateTrigger(t1);
        ts = this.loader.loadTriggers();
        Assert.assertTrue((!((Trigger)ts.get(0)).isResetOnExpire() ? 1 : 0) != 0);
    }

    private Trigger createTrigger(String projName, String flowName, String source) {
        DateTime now = DateTime.now();
        BasicTimeChecker checker1 = new BasicTimeChecker("timeChecker1", now.getMillis(), now.getZone(), true, true, Utils.parsePeriodString((String)"1h"));
        HashMap<String, BasicTimeChecker> checkers1 = new HashMap<String, BasicTimeChecker>();
        checkers1.put(checker1.getId(), checker1);
        String expr1 = String.valueOf(checker1.getId()) + ".eval()";
        Condition triggerCond = new Condition(checkers1, expr1);
        Condition expireCond = new Condition(checkers1, expr1);
        ArrayList<ExecuteFlowAction> actions = new ArrayList<ExecuteFlowAction>();
        ExecuteFlowAction action = new ExecuteFlowAction("executeAction", 1, projName, flowName, "azkaban", new ExecutionOptions(), null);
        actions.add(action);
        Trigger t = new Trigger(now.getMillis(), now.getMillis(), "azkaban", source, triggerCond, expireCond, actions);
        return t;
    }
}

