/*
 * Decompiled with CFR 0.152.
 */
package azkaban.scheduler;

import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.project.ProjectManager;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleLoader;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.scheduler.TriggerBasedScheduleLoader;
import azkaban.sla.SlaOption;
import azkaban.trigger.TriggerManager;
import azkaban.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TriggerBasedScheduler {
    private static Logger logger = Logger.getLogger(TriggerBasedScheduler.class);
    private final DateTimeFormatter _dateFormat = DateTimeFormat.forPattern((String)"MM-dd-yyyy HH:mm:ss:SSS");
    private ScheduleLoader loader;
    private Map<Pair<Integer, String>, Schedule> scheduleIDMap = new HashMap<Pair<Integer, String>, Schedule>();
    private Map<Integer, Schedule> idFlowMap = new HashMap<Integer, Schedule>();

    public TriggerBasedScheduler(ExecutorManagerAdapter executorManager, ProjectManager projectManager, TriggerManager triggerManager, ScheduleLoader loader) {
        this.loader = new TriggerBasedScheduleLoader(triggerManager, executorManager, projectManager, "SimpleTimeTrigger");
        List<Schedule> scheduleList = null;
        try {
            scheduleList = loader.loadSchedules();
        }
        catch (ScheduleManagerException e) {
            logger.error((Object)("Failed to load schedules" + e.getCause() + e.getMessage()));
            e.printStackTrace();
        }
        for (Schedule s : scheduleList) {
            this.scheduleIDMap.put(s.getScheduleIdentityPair(), s);
            this.idFlowMap.put(s.getScheduleId(), s);
        }
    }

    public synchronized List<Schedule> getSchedules() {
        return new ArrayList<Schedule>(this.scheduleIDMap.values());
    }

    public Schedule getSchedule(int projectId, String flowId) {
        return this.scheduleIDMap.get(new Pair<Integer, String>(projectId, flowId));
    }

    public synchronized void removeSchedule(int projectId, String flowId) {
        Schedule s = this.getSchedule(projectId, flowId);
        if (s != null) {
            this.removeSchedule(s);
        }
    }

    public synchronized void removeSchedule(Schedule sched) {
        Pair<Integer, String> identityPairMap = sched.getScheduleIdentityPair();
        Schedule s = this.scheduleIDMap.get(identityPairMap);
        if (s != null) {
            this.scheduleIDMap.remove(sched.getScheduleId());
        }
        try {
            this.loader.removeSchedule(sched);
        }
        catch (ScheduleManagerException e) {
            e.printStackTrace();
        }
    }

    public Schedule scheduleFlow(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser) {
        return this.scheduleFlow(scheduleId, projectId, projectName, flowName, status, firstSchedTime, timezone, period, lastModifyTime, nextExecTime, submitTime, submitUser, null, null);
    }

    public Schedule scheduleFlow(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions execOptions, List<SlaOption> slaOptions) {
        Schedule sched = new Schedule(scheduleId, projectId, projectName, flowName, status, firstSchedTime, timezone, period, lastModifyTime, nextExecTime, submitTime, submitUser, execOptions, slaOptions);
        logger.info((Object)("Scheduling flow '" + sched.getScheduleName() + "' for " + this._dateFormat.print(firstSchedTime) + " with a period of " + period == null ? "(non-recurring)" : period));
        this.insertSchedule(sched);
        return sched;
    }

    public synchronized void insertSchedule(Schedule s) {
        block5: {
            boolean exist;
            boolean bl = exist = s.getScheduleId() != -1;
            if (s.updateTime()) {
                try {
                    if (!exist) {
                        this.loader.insertSchedule(s);
                        this.scheduleIDMap.put(s.getScheduleIdentityPair(), s);
                        break block5;
                    }
                    this.loader.updateSchedule(s);
                    this.scheduleIDMap.put(s.getScheduleIdentityPair(), s);
                }
                catch (ScheduleManagerException e) {
                    e.printStackTrace();
                }
            } else {
                logger.error((Object)("The provided schedule is non-recurring and the scheduled time already passed. " + s.getScheduleName()));
            }
        }
    }
}

